package com.digiwin.athena.agiledataecho.mongodb.domain;

import com.digiwin.athena.agiledataecho.dto.mongodb.metric.MetricCheckResDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: SunHong
 * @Date: 2024/11/11 19:01
 * @Description:
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document("agile_echo_metric_check_data")
public class MetricCheckMongoData implements Serializable {

    @Id
    private String id;

    private Long messageId;

    private Date createTime;

    private List<MetricCheckResDTO.Tabs> tabs;

}
