package com.digiwin.athena.agiledataecho.proxy;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * AthenaDapApiResponse
 *
 * @author yanfeng
 * @date 2024/7/23
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AthenaDapApiResponse<T> implements Serializable {
    private static final long serialVersionUID = 6217160114197374344L;

    private Long duration;
    private Integer status;
    private String statusDescription;
    // 异常情况下，返回的是字符串或null
    private T response;
    private String errorMessage;
    private String code;
    // 异常情况下，返回的是Map或者字符串
    private Object debugInfo;
    private String description;
    private String errorCode;
}