package com.digiwin.athena.agiledataecho.proxy.adt;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataHooks;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenModel;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.board.SnapShotInfo;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;

import java.util.Map;

/**
 * 敏数快照管理服务
 */
public interface AdtService {

    /**
     * 获取快照信息
     * @param user
     * @param snapshotId
     * @param locale
     * @return
     */
    Map<String, Object> getSnapShotInfo(AuthoredUser user,String snapshotId,String locale);

    /**
     * 获取快照信息
     * @param user
     * @return
     */
    Integer getChargingUserValue(AuthoredUser user);

    /**
     * 获取敏捷报表基础信息
     * @param reportId
     * @param locale
     * @return
     */
    SnapDataDTO getAdtReportBySnapshotId(String reportId, String locale);

    /**
     * 获取敏捷数据实时整合数据流
     * @param agileDataScreenDTO
     * @param locale
     * @return
     */
    SnapDataDTO getAdtSyncReportMoreScene(AgileDataScreenDTO agileDataScreenDTO, String locale);

    /**
     * 获取敏捷数据整合数据流
     * @param sceneCode
     * @param locale
     * @return
     */
    SnapDataDTO getAdtReportMoreScene(String sceneCode, String locale);

    /**
     * 获取敏捷数据hooks信息
     * @param type
     * @param locale
     * @return
     */
    AgileDataHooks getAgileDataHooks(String type, String locale);

    /**
     * 获取敏捷数据大屏模板信息
     * @param modelId
     * @param locale
     * @return
     */
    AgileDataScreenModel getAgileDataScreenModel(String modelId, String locale);

    /**
     * 获取转换数据
     * @param transId
     * @param snapshotId
     * @return
     */
    SnapDataDTO transAgileData(String transId, String snapshotId,String locale);

    /**
     * 获取看板数据
     * @param boardLayoutParamsDTO
     * @return
     */
    SnapShotInfo getBoardData(BoardLayoutParamsDTO boardLayoutParamsDTO,String locale);



}
