package com.digiwin.athena.agiledataecho.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author wuyang
 * @desc 日志工具栏
 * @date 20224/12/12
 */
@Slf4j
public final class LogUtils {

    /**
     * 组件ID-----moduleId的枚举值
     */
    public static final String MODULE_ADT = "adt";

    public static final String MODULE_ECHO = "agiledataecho";
    public static final String MODULE_SCRUM_BI = "scrumbi";
    public static final String MODULE_ADE = "agiledataengine";
    public static final String MODULE_EE = "executionEngine";
    public static final String MODULE_RECAST = "recast";
    public static final String MODULE_DCD = "dcdpinteract";
    public static final String MODULE_DCC = "DCC";
    public static final String MODULE_KM = "knowledgegraph";
    public static final String MODULE_ADP = "adp";
    public static final String MODULE_A_ADC = "aadc";
    public static final String MODULE_A_ADC_S = "aadcs";

    /**
     * 日志记录展示的组件信息
     */
    private static final String MODULE_ADT_DESC = "ADT - 敏捷数据入口";
    private static final String MODULE_SCRUM_BI_DESC = "gpt - 语义分析";
    private static final String MODULE_ADE_DESC = "ADE - 敏捷数据引擎";
    private static final String MODULE_EE_DESC = "EE - 执行引擎";
    private static final String MODULE_RECAST_DESC = "RECAST - 二次计算";
    private static final String MODULE_DCD_DESC = "DCD - 边缘数据中心";
    private static final String MODULE_DCC_DESC = "DCC - 模型中心";
    private static final String MODULE_KM_DESC = "KM - 知识图谱";
    private static final String MODULE_ADP_DESC = "adp - 设计器";
    private static final String MODULE_A_ADC_DESC = "aadc - 设计器发版服务";
    private static final String MODULE_A_ADC_S_DESC = "aadcs - 设计器发版服务";

    /**
     * 请求的状态码
     */
    public static final String SUCCESS = "1";
    public static final String WARING = "0";

    public static final String ERROR = "-1";

    /**
     * 敏捷数据日志前缀
     */
    public static final String AGILE_DATA_LOG_PREFIX = "agiledata_";


    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);

    /**
     * 构建日志
     * @param moduleId moduleId
     * @param step step
     * @param code code
     * @param input input
     * @param result result
     * @param suggestion suggestion
     */
    public static void buildAgileLog(String moduleId, String step ,String code, String input,
                                     String result, String suggestion){
        Log log;
        //代表执行成功
        if(SUCCESS.equalsIgnoreCase(code)){
            log = buildSuccessLog(buildModuleId(moduleId), step, input, result, suggestion);
        }else if(WARING.equalsIgnoreCase(code)){
            log = buildWaringLog(buildModuleId(moduleId), step, input, result, suggestion);
        }else {
            log = buildErrorLog(buildModuleId(moduleId), step, input, result, suggestion);
        }
        LOGGER.error(AGILE_DATA_LOG_PREFIX + moduleId + "_请求过程为_" + JsonUtils.objectToString(log));
    }

    private static String buildModuleId(String moduleId) {
        if(MODULE_ADT.equalsIgnoreCase(moduleId)){
            return MODULE_ADT_DESC;
        }else if(MODULE_ADE.equalsIgnoreCase(moduleId)){
            return MODULE_ADE_DESC;
        }else if(MODULE_SCRUM_BI.equalsIgnoreCase(moduleId)){
            return MODULE_SCRUM_BI_DESC;
        }else if(MODULE_EE.equalsIgnoreCase(moduleId)){
            return MODULE_EE_DESC;
        }else if(MODULE_RECAST.equalsIgnoreCase(moduleId)){
            return MODULE_RECAST_DESC;
        }else if(MODULE_DCD.equalsIgnoreCase(moduleId)){
            return MODULE_DCD_DESC;
        }else if(MODULE_DCC.equalsIgnoreCase(moduleId)){
            return MODULE_DCC_DESC;
        }else if(MODULE_KM.equalsIgnoreCase(moduleId)){
            return MODULE_KM_DESC;
        }else if(MODULE_ADP.equalsIgnoreCase(moduleId)){
            return MODULE_ADP_DESC;
        }else if(MODULE_A_ADC.equalsIgnoreCase(moduleId)){
            return MODULE_A_ADC_DESC;
        }else if(MODULE_A_ADC_S.equalsIgnoreCase(moduleId)){
            return MODULE_A_ADC_S_DESC;
        }else {
            return moduleId;
        }
    }


    private static Log buildSuccessLog(String moduleId, String step, String input,
                                       String result, String suggestion) {
        return new Log("SUCCESS", moduleId, step, SUCCESS, input,result, suggestion);
    }

    private static Log buildWaringLog(String moduleId, String step, String input,
                                      String result, String suggestion) {
        return new Log("WARING", moduleId, step, WARING, input, result, suggestion);
    }

    private static Log buildErrorLog(String moduleId, String step, String input,
                                     String result, String suggestion) {
        return new Log("ERROR", moduleId, step, ERROR, input, result, suggestion);
    }


    @Data
    public static class Log{

        private String logType;

        private String productComponent;

        private String step;

        private String code;

        private String input;

        private String result;

        private String suggestion;


        public Log(String logType, String productComponent, String step, String code, String input,
                   String result, String suggestion) {
            this.logType = logType;
            this.productComponent = productComponent;
            this.step = step;
            this.code = code;
            this.input = input;
            this.result = result;
            this.suggestion = suggestion;
        }
    }

    public static void main(String[] args) {
        Set<String> actionParams = new HashSet<>(2);
        Set<String> sysParamKeys = new HashSet<>(2);
        actionParams.add("asssqq");
        actionParams.add("27902");
        Map<String, Object> reqMap = new HashMap<>(4);
        reqMap.put("actionId", "fsa12d2344fs");
        reqMap.put("tenantId", "agiledemo");
        reqMap.put("actionParams", actionParams);
        reqMap.put("sysParams", sysParamKeys);
        //正确的请求日志
        buildAgileLog(LogUtils.MODULE_ECHO, "getExecutionRule", LogUtils.SUCCESS,
                JsonUtils.objectToString(reqMap), "", "");
        //错误的请求日志
        buildAgileLog(LogUtils.MODULE_ECHO, "getExecutionRule", "502",
                JsonUtils.objectToString(reqMap), "", "地端MQ短线，请联系客户检查");
    }
}
