package com.digiwin.athena.agiledataecho.util;

import com.github.houbb.opencc4j.util.ZhTwConverterUtil;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

import java.util.Objects;

public class SystemLanguageUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(SystemLanguageUtils.class);

    private static final String translationApi = "/restful/service/translater/IDWTranslateService/translate";

    private static final String TRADITIONAL_TO_SIMPLE="zh2Hans";

    private static final String SIMPLE_TO_TRADITIONAL="zh2Hant";

    private static final CloseableHttpClient httpClient;

    private static final String translationUlr = "https://translation.digiwincloud.com";
    private SystemLanguageUtils() {

    }

    static {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(2, true));
            httpClientBuilder.setKeepAliveStrategy((response, context) -> {
                HeaderElementIterator iterator = new BasicHeaderElementIterator(
                        response.headerIterator(HTTP.CONN_KEEP_ALIVE));
                while (iterator.hasNext()) {
                    HeaderElement headerElement = iterator.nextElement();
                    String value = headerElement.getValue();
                    if (StringUtils.equalsIgnoreCase(headerElement.getName(),"timeout") && StringUtils.isNumeric(value) ) {
                        return Long.parseLong(value) * 1000;
                    }
                }
                return 30 * 1000;
            });

        httpClient = httpClientBuilder.build();
    }
    /**
     * 繁体转为简体
     * @param original 繁体内容
     * @return 转换后的简体
     */
    public static String toSimple(final String original) {
        return ZhTwConverterUtil.toSimple(original);
    }

    /**
     * 简体转为繁体
     * @param original 简体内容
     * @return 转换后的繁体
     */
    public static String toTraditional(final String original) {
        return ZhTwConverterUtil.toTraditional(original);
    }

    public static String toDAPTraditional(final String original) {
        String translate = translate(original, SIMPLE_TO_TRADITIONAL);
        if(StringUtils.isNotEmpty(translate)){
            return translate;
        }
        return ZhTwConverterUtil.toTraditional(original);
    }

    public static String toDAPSimple(final String original) {
        String translate = translate(original, TRADITIONAL_TO_SIMPLE);
        if(StringUtils.isNotEmpty(translate)){
            return translate;
        }
        return ZhTwConverterUtil.toSimple(original);
    }

    /**
     * 翻译
     * @param original 翻译前内容
     * @param convertType 翻译的语言
     * @return 翻译后的内容
     */
    private static String translate(final String original, final String convertType){
        String content=null;
        CloseableHttpResponse response = null;
        try{
            response = httpClient.execute(buildRequest(original, convertType));
            // 判断状态码是否是200
            if (response.getStatusLine().getStatusCode() == HttpStatus.OK.value()) {
                // 解析数据
                content = EntityUtils.toString(response.getEntity(), "UTF-8");
                JSONObject result = JSONObject.fromObject(content);
                boolean success = result.getJSONObject("response").getBoolean("success");
                if (!success) {
                    LOGGER.info("SystemLanguageUtils.translate result:{}",content);
                    return "";
                }
                return result.getJSONObject("response").getJSONObject("data").getString(convertType);
            }
            return "";
        }catch (Exception e){
            LOGGER.error("SystemLanguageUtils.translate is error original:{},convertType:{},result:{}",original,convertType,content,e);
            return "";
        }finally {
            closeableHttpResponse(response);
        }
    }

   private static void closeableHttpResponse(CloseableHttpResponse response){
        try{
            if(Objects.nonNull(response)){
                response.close();
            }
        }catch (Exception ex){
            LOGGER.error("closeableHttpResponse is error",ex);
        }
   }

    private static HttpPost buildRequest(final String original, final String convertType){
        HttpPost httpPost = new HttpPost(translationUlr + translationApi);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("content", original);
        JSONArray convertTypesArray = new JSONArray();
        convertTypesArray.put(convertType);
        jsonObject.put("convertTypes", convertTypesArray);
        StringEntity entity = new StringEntity(jsonObject.toString(), Consts.UTF_8);
        entity.setContentType(MediaType.APPLICATION_JSON_VALUE);
        httpPost.setEntity(entity);
        return httpPost;
    }

}
