package com.digiwin.athena.show.component.grid;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

@Service(ComponentNameConstants.GRID_COMPONENT)
public class GridComponentImpl extends AbstractComponentService {

    private static final String COMPONENT_TYPE = "TABLE";

    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        GridComponent gridComponent = new GridComponent();
        if(metadataField == null){
            return gridComponent;
        }
        List<MetadataField> showFields = getShowFields(metadataField);
        if(CollectionUtils.isEmpty(showFields)){
            return gridComponent;
        }
        gridComponent.setId(buildContext.getThemeMapReport().getActionId());
        gridComponent.setType(COMPONENT_TYPE);
        gridComponent.setTitle(buildContext.getThemeMapReport().getTitle());
        List<GridColumnDef> columns = Lists.newArrayList();
        //设置宽度
        WidthCalculator.calColumnWidth(showFields, buildContext.getThemeMapReport().getPageData());
        showFields.stream().forEach(field -> {
            GridColumnDef column = new GridColumnDef();
            column.setId(field.getName());
            column.setName(field.getDescription());
            column.setWidth(field.getDisplayWidth());
            //度量字段，增加格式化信息
            if(!StringUtils.pathEquals("string",field.getDataType())) {
                ComponentFormat componentFormat = new ComponentFormat();
                componentFormat.setDecimal(field.getDecimal());
                componentFormat.setPercent(field.getPercent());
                componentFormat.setBusinessType(field.getBusinessType());
                componentFormat.setDecimalRule(ConvertAgileDataUtils.getDecimalRule(field.getDecimalRule()));
                componentFormat.setUnit(ConvertAgileDataUtils.getUnitRule(field.getUnit()));
                column.setFormat(componentFormat);
            }
            columns.add(column);
        });
        gridComponent.setColumns(columns);
        gridComponent.setShowData(buildContext.getThemeMapReport().getPageData());
        return gridComponent;
    }


    /**
     * 获取可呈现字段
     * @param metadataField
     * @return
     */
    private List<MetadataField> getShowFields(MetadataField metadataField) {
        List<MetadataField> fields = Lists.newArrayList();
        if (metadataField.isObjectField()) {
            metadataField.getSubFields().forEach(field -> fields.addAll(getShowFields(field)));
        } else {
            fields.add(metadataField);
        }
        return fields;
    }
}
