package com.digiwin.athena.show.component.index;

import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 指标卡
 */
@Service(ComponentNameConstants.STATISTIC)
public class AgileDataIndexComponentImpl extends AbstractComponentService {

    private static final String COMPONENT_TYPE = "STATISTIC";

    public AgileDataIndexComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        AgileDataIndexComponent indexComponent = new AgileDataIndexComponent();
        ThemeMapReport themeMapReport = buildContext.getThemeMapReport();
        Map<String,Object> data = Maps.newHashMap();
        List<Map<String,Object>> pageData = themeMapReport.getPageData();
        if(CollectionUtils.isNotEmpty(pageData)){
            data = pageData.get(0);
        }
        indexComponent.setType(COMPONENT_TYPE);
        indexComponent.setId(themeMapReport.getActionId());
        indexComponent.setTitle(themeMapReport.getTitle());
        List<AgileDataIndexComponent.AgileDataIndex> indexList = Lists.newArrayList();
        Map<String,MetadataField> filedMap = ConvertGetAgileData.getAgileData(themeMapReport.getActionId(),themeMapReport.getApiMetadata());
        if(MapUtils.isNotEmpty(filedMap)){
            Map<String, Object> finalData = data;
            filedMap.forEach((metadataFieldName, field)->{
                AgileDataIndexComponent.AgileDataIndex index = new AgileDataIndexComponent.AgileDataIndex();
                index.setName(field.getDescription());
                index.setValue(finalData.get(field.getName()));
                index.setTip(field.getExplanation());
                //格式化数据
                ComponentFormat componentFormat = new ComponentFormat();
                componentFormat.setDecimal(field.getDecimal());
                componentFormat.setPercent(field.getPercent());
                componentFormat.setBusinessType(field.getBusinessType());
                componentFormat.setDecimalRule(ConvertAgileDataUtils.getDecimalRule(field.getDecimalRule()));
                componentFormat.setUnit(ConvertAgileDataUtils.getUnitRule(field.getUnit()));
                index.setFormat(componentFormat);
                indexList.add(index);
            });
        }
        indexComponent.setGroup(indexList);
        return indexComponent;
    }



}
