package com.digiwin.athena.show.component.list;


import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.springframework.stereotype.Service;


/**
 * 列表组件
 */
@Service(ComponentNameConstants.LIST_COMPONENT)
public class ListComponentImpl extends AbstractComponentService {



    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        ListComponent listComponent = new ListComponent();
        listComponent.setId(metadataField.getName());
        listComponent.setType(ComponentNameConstants.LIST_COMPONENT);
        listComponent.setId(metadataField.getName());
        listComponent.setHeaderName(metadataField.getDescription());
        return listComponent;
    }

}
