package com.digiwin.athena.show.component.progressBar;


import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.infrastructure.component.ComponentNameConstants;
import com.digiwin.athena.show.metadata.MetadataField;
import org.springframework.stereotype.Service;


/**
 * @Author: SunHong
 * @Date: 2024/8/8 13:53
 * @Description:
 */
@Service(ComponentNameConstants.PROGRESS_BAR)
public class ProgressBarComponentImpl extends AbstractComponentService {


    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        ProgressBarComponent progressBarComponent = new ProgressBarComponent();
        progressBarComponent.setId(metadataField.getName());
        progressBarComponent.setType(ComponentNameConstants.PROGRESS_BAR);
        progressBarComponent.setId(metadataField.getName());
        progressBarComponent.setHeaderName(metadataField.getDescription());
        return progressBarComponent;
    }
}
