package com.digiwin.athena.show.controller;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.assistant.AgileDataConstants;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/api/ai/v1/agile/")
public class AgileReportController {

    @Autowired
    private AgileReportService agileReportService;

    @Autowired
    private AdtService adtService;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    CacheManager cacheManager;

    /**
     * 敏数呈现DSL结构
     */
    @GetMapping("report/show/{reportId}")
    public ResponseEntity<?> createAgileReportPageTemplate(@PathVariable("reportId") String snapshotId,
                                                           @RequestParam(value = "entry", required = false) String entry,
                                                           @RequestParam(value = "module", required = false) Integer module) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        if(StringUtils.isEmpty(entry)){
            entry = "0";
        }
        //获取敏捷报表信息
        SnapDataDTO agileReportDTO = adtService.getAdtReportBySnapshotId(snapshotId, executeContext.getLocale());
        if (AgileDataCheck.sceneBasicCheck(agileReportDTO)) {
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        executeContext.appendAgileDataPageInfo(AgileDataConstants.REPORT_PAGE, agileReportDTO,agileReportDTO.getSnapData().getReportCode(),entry);
        //解析报表信息
        return ResponseEntityWrapper.wrapperOk(agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO));
    }

    /**
     * 通过模板生成敏捷报表
     */
    @PostMapping("transPresent")
    public ResponseEntity<?> transAgileData(@RequestBody Map<String,Object> transParams) {
        String snapshotId = transParams.get("snapshotId").toString();
        String transId = transParams.get("transId").toString();
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        executeContext.setTransId(transId);
        //获取敏捷报表信息
        SnapDataDTO agileReportDTO = adtService.transAgileData(transId, snapshotId,executeContext.getLocale());
        if (AgileDataCheck.sceneBasicCheck(agileReportDTO)) {
            throw BusinessException.create(ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        executeContext.appendAgileDataPageInfo(AgileDataConstants.REPORT_PAGE, agileReportDTO,null,"0");
        DynamicAgileData dynamicForm = agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO);
        Map<String,Object> result = Maps.newHashMap();
        result.put("dsl",dynamicForm);
        result.put("dataTipMessage",agileReportDTO.getSnapData().getTransTips());
        return ResponseEntityWrapper.wrapperOk(result);
    }

    @GetMapping("clean/agileData/rest")
    public ResponseEntity<?> cleanAgileDataRest(@RequestParam(value = "redisKey", required = false) String redisKey) {
        cacheManager.delete("adt:cache:", redisKey);
        return ResponseEntityWrapper.wrapperOk(true);
    }

}
