package com.digiwin.athena.show.controller;


import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.domain.board.BoardLayoutDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.dynamicLayout.BordDynamicDTO;
import com.digiwin.athena.show.service.DynamicLayoutBoardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping(value = "/api/ai/v1/board/")
public class DynamicLayoutBoardController {


    @Autowired
    private DynamicLayoutBoardService dynamicLayoutBoardService;

    /**
     * 动态布局计算
     * @param request
     * @param bordDynamicDTO
     * @return
     */
    @PostMapping("dynamicLayout")
    public ResponseEntity<?> transAgileData(HttpServletRequest request,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                            @RequestBody BordDynamicDTO bordDynamicDTO) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(dynamicLayoutBoardService.calcDynamicLayoutBoard(user,bordDynamicDTO,locale));
    }

    @PostMapping("buildBoardPresented")
    public ResponseEntity<?> generateBoardLayout(HttpServletRequest request,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                            @RequestBody BoardLayoutParamsDTO bordDynamicDTO) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(dynamicLayoutBoardService.generateBoardLayout(user,bordDynamicDTO,locale));
    }

    /**
     * 保存动态布局
     * @param request
     * @param boardLayout
     * @return
     */
    @PostMapping("saveBoardLayout")
    public ResponseEntity<?> saveBoardLayout(HttpServletRequest request,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                             @RequestBody BoardLayoutDTO boardLayout) {
        return ResponseEntityWrapper.wrapperOk(dynamicLayoutBoardService.saveDynamicLayoutBoard(user,boardLayout));
    }

    /**
     * 保存动态布局
     * @param request
     * @param boardId
     * @return
     */
    @GetMapping("getBoardLayout")
    public ResponseEntity<?> getBoardLayout(HttpServletRequest request,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                            @RequestParam(value = "boardId", required = false) String boardId) {
        return ResponseEntityWrapper.wrapperOk(dynamicLayoutBoardService.getDynamicLayoutBoard(user,boardId));
    }

}
