package com.digiwin.athena.show.domain.agileDataDTO;

import lombok.Data;

import java.util.List;

/**
 * 多轴区域
 */
@Data
public class AgileDataAreaDefine {

    /**
     * 映射字段集
     */
    private List<String> applyToFields;

    /**
     * 进度条类型
     */
    private String progressType;

    /**
     * 映射字段
     */
    private String applyToField;

    /**
     * 字段位置
     */
    private String  position;

    /**
     * 字段大小
     */
    private Integer level;

    /**
     * 图形类型
     */
    private String chart;

    /**
     * 区域类型
     */
    private String type;

    /**
     * 呈现字段
     */
    private String label;

    /**
     * 是否展示字段
     */
    private Boolean showLabel;

    /**
     * 颜色
     */
    private String color;

    /**
     * 格式化
     */
    private String format;

    //指定呈现字段排列顺序(horizontal | vertical)
    private String fieldsLayout;

    /**
     * 内部区域
     */
    private List<AgileDataAreaDefine> areaDefine;

}
