package com.digiwin.athena.show.domain.agileDataDTO;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 敏捷报表定义
 */
@Data
public class AgileDataDefine {

    /**
     * 数据标题
     */
    private String sceneTitle;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 轮播时间
     */
    private Integer pageTurningFrequency;

    /**
     * 场景编码
     */
    private String sceneCode;

    /**
     * eCharts组件
     */
    private AgileReportECharts agileReportECharts;

    /**
     * 展现形式0.table1.echarts2.指标
     */
    private Integer reportShow;

    /**
     * 数据源
     */
    private String targetSource;

    /**
     * 敏捷规则
     */
    private List<AgileReportRuleDTO> agileRules;

    /**
     * 敏捷指标
     */
    private AgileReportIndex agileReportIndex;

    /**
     * 敏捷卡片
     */
    private AgileReportCard agileReportCard;

    /**
     * 维度区间
     */
    private Map<String,Object> dimensionInterval;

    /**
     * 时间粒度
     */
    List<AgileDataAliasGrainDTO> aliasGrain;

    /**
     * 敏捷数据业务字段标签
     */
    private List<AgileDataTag> agileDataTag;

    /**
     * 数据流关系
     */
    private List<AgileDataRelationDTO> agileDataRelation;

}
