package com.digiwin.athena.show.domain.agileDataDTO;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * 数据流布局
 */
@Data
public class AgileDataGridsterArrange {

    /**
     * 区域整体宽度
     */
    private int width;

    /**
     * 翦整体高度
     */
    private int height;

    /**
     * 分组集合
     */
    private List<AgileDataGridsterGroup> groups = Lists.newArrayList();

    public void setSize(){
        this.width = 0;
        this.height = 0;
        groups.stream().forEach(group -> {
            this.width += group.getWidth();
            this.height = group.getHeight();
        });
    }

    /**
     * 重新计算分组宽高
     */
    public void reSize(int maxWidth){
        this.groups.stream().forEach(group -> {
            //重新按最大宽度计算区域宽高
            group.reSize(this.width,maxWidth);
        });
        //拉奇高度
//        Optional<AgileDataGridsterGroup> groupOptional = groups.stream().max(Comparator.comparing(AgileDataGridsterGroup::getHeight));
//        if(groupOptional.isPresent()){
//            AgileDataGridsterGroup maxHeightGroup = groupOptional.get();
//            //根据最大高度，补齐原有结构
//            groups.stream().forEach(group -> {
//                if(group.getHeight() != maxHeightGroup.getHeight()){
//                    //组内元素按比例计算宽高
//                    group.getAreas().stream().forEach(area -> {
//                        //取目前元素在组内占比
//                        double proportionHeight = Double.valueOf(area.getRows()) / Double.valueOf((group.getHeight()));
//                        //根据占比重新计算元素高度
//                        area.setRows((int) (maxHeightGroup.getHeight() * proportionHeight));
//                    });
//                    //重新设置区域高度
//                    group.setSize();
//                }
//            });
//        }
        //重新计算当前行宽高
        this.setSize();
    }

    /**
     * 补齐宽度
     */
    public void completionSize(){
        //分组宽度
        int prevWidth = 0;
        int size = 0;
        for(AgileDataGridsterGroup group : this.groups){
            group.completionSize(this.width,prevWidth,size == this.groups.size() - 1);
            prevWidth += group.getWidth();
        }
        this.setSize();
    }


    /**
     * 设定坐标
     */
    public void setCoordinate(int prevHeight){
        int groupWidth = 0;
        for(AgileDataGridsterGroup group : this.groups) {
            group.calcCoordinate(groupWidth,prevHeight);
            groupWidth += group.getWidth();
        }
    }

}
