package com.digiwin.athena.show.domain.agileDataDTO;

import org.apache.commons.lang.StringUtils;

public enum AgileReportChartTypeEnum {

    /**
     * 不等宽柱形图
     */
    BAR_1("不等宽柱形图","bar",null),
    /**
     * 柱形图
     */
    BAR_2("柱形图","bar",3),

    BAR_3("直方图","bar",3),

    CATEGORY_1("堆积柱形图","category",null),

    CATEGORY_LINE_1("堆积百分比柱形图","category",null),

    LINE_1("曲线图","line",5),

    MIXED("混合图","mixed",4),

    PIE_1("饼图","pie",6);

    private String type;

    private String name;

    private Integer value;


    AgileReportChartTypeEnum(String name,String type,Integer value){
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public static String getType(String name) {
        for(AgileReportChartTypeEnum agileReportChartTypeEnum : AgileReportChartTypeEnum.values()){
            if(StringUtils.equals(agileReportChartTypeEnum.name,name)){
                return agileReportChartTypeEnum.type;
            }
        }
        return null;
    }

    public static String getTypeByValue(Integer value) {
        for(AgileReportChartTypeEnum agileReportChartTypeEnum : AgileReportChartTypeEnum.values()){
            if(value.equals(agileReportChartTypeEnum.value)){
                return agileReportChartTypeEnum.type;
            }
        }
        return null;
    }


}
