package com.digiwin.athena.show.domain.agileDataDTO;

import lombok.Data;

import java.util.List;

@Data
public class AgileReportECharts {

    /**
     * x轴定义
     */
    private XAis xAxis;

    /**
     * eCharts标题
     */
    private String title;

    /**
     * y轴定义
     */
    private Series series;

    /**
     * 图表类型
     */
    private String chartType;

    /**
     * 图表数据定义
     */
    private List<EChartsData> data;

    /**
     * 图表数据定义
     */
    private EChartsData points;

    /**
     * 工具栏
     */
    private List<String> toolBox;


    @Data
    public static class XAis{

        //数据源
        private String target;

        //目标字段
        private String applyToField;
    }

    @Data
    public static class Series{

        //数据源
        private List<XAis> data;

    }

    @Data
    public static class EChartsData{

         private List<EChartsDataDefine> points;

         private List<EChartsDataDefine> values;
    }

    @Data
    public static class EChartsDataDefine{

        private String applyToField;

        /**
         * 该字段呈现类型
         */
        private String chart;
    }

}
