package com.digiwin.athena.show.domain.agileDataDTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class AgileReportShow {

    /**
     * 数据源
     */
    private String actionId;

    /**
     * 图表定义
     */
    @JsonProperty("eChart")
    private List<AgileReportEChartDefineDTO> eChart;

    /**
     * 表格定义
     */
    private AgileReportTableDefineDTO table;

    /**
     * 敏捷规则
     */
    private List<AgileReportRuleDTO> agileRule;

    /**
     * 卡片定义
     */
    private AgileReportCardDTO card;

    /**
     * 敏捷指标
     */
    private AgileReportIndex agileReportIndex;

    /**
     * 数据来源结构
     */
    private String targetSource;

}
