package com.digiwin.athena.show.domain.agileDataDTO;


import java.util.Arrays;
import java.util.List;

public enum AgileReportShowTypeEnum {

    /**
     * 图形
     */
    ECHARTS("ECHARTS",Arrays.asList("1","3","4","5","6")),
    /**
     * 表格
     */
    TABLE("ATHENA_TABLE", Arrays.asList("0")),

    /**
     * 指标卡
     */
    INDEX("STATISTIC", Arrays.asList("2")),

    /**
     * 卡片
     */
    CARD("CARD", Arrays.asList("7"));

    private String showType;

    private List<String> defineTypes;


    AgileReportShowTypeEnum(String showType, List<String> defineTypes){
        this.showType = showType;
        this.defineTypes = defineTypes;
    }

    public static String getType(String type) {
        for(AgileReportShowTypeEnum agileReportShowTypeEnum : AgileReportShowTypeEnum.values()){
            if(agileReportShowTypeEnum.defineTypes.contains(type)){
                return agileReportShowTypeEnum.showType;
            }
        }
        return null;
    }

}
