package com.digiwin.athena.show.domain.agileDataDTO;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 语义分析呈现形式
 */
public enum ChartBITypeEnum {

    BAR("bar","柱形图"),
    LINE("line","曲线图"),
    SCATTER("scatter","散点图"),
    FUNNEL("funnel","漏斗图"),
    PIE("pie","饼图"),
    GAUGE("gauge","仪表盘"),
    CARD("card","2"),
    TABLE("table","0");


    @Getter
    private String value;

    private String biValue;

    ChartBITypeEnum(String biValue,String value) {
        this.value = value;
    }

    public static String getValue(String biValue){
        for(ChartBITypeEnum chartBITypeEnum :ChartBITypeEnum.values()){
            if(StringUtils.equals(biValue,chartBITypeEnum.biValue)){
                return chartBITypeEnum.getValue();
            }
        }
        return null;
    }

}
