package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.util.layout.AgileDataGridsterBestShow;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 敏捷数据呈现布局
 */
public class ConvertAgileDataRelation{

    private ConvertAgileDataRelation() {
        throw new IllegalStateException("Utility class");
    }



    private static List<String> sortComponent = Lists.newArrayList("LABEL","STATISTIC","ECHARTS","ATHENA_TABLE","PANEL","LIST","CARD");
    /**
     * 敏捷数据呈现
     * @param agileDataRelationDTOList
     * @return
     */
    public static List<GridGroupDTO> gridGroupDTOS(List<AgileDataRelationDTO> agileDataRelationDTOList,
                                                   List<AgileDataBestShowRule> bestShowRules, List<AbstractComponent> abstractComponents, ExecuteContext executeContext) {
        Map<String,Object> agileDataMap = executeContext.getAgileData();
        //大屏算法
        if(MapUtils.isNotEmpty(agileDataMap) && agileDataMap.containsKey("entry")){
            String entry = MapUtils.getString(agileDataMap,"entry");
            if(StringUtils.equals("1",entry)){
                return AgileDataGridsterBestShow.createItems(agileDataRelationDTOList,abstractComponents,executeContext);
            }
        }
        //非大屏算法
        return createItems(agileDataRelationDTOList,bestShowRules,abstractComponents,null);
    }

    /**
     * 场景区域对象
     * @param agileDataRelationDTOList
     * @return
     */
    public static List<GridGroupDTO> createItems(List<AgileDataRelationDTO> agileDataRelationDTOList,
                                                 List<AgileDataBestShowRule> bestShowRules,
                                                 List<AbstractComponent> components,
                                                 BoardLayoutMongoData userDefineLayout) {
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        //获取所有组件
        List<AbstractComponent> abstractComponents = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(agileDataRelationDTOList)) {
            agileDataRelationDTOList.stream().forEach(agileDataRelationDTO -> {
                if (agileDataRelationDTO.getAbstractComponents() != null) {
                    abstractComponents.addAll(agileDataRelationDTO.getAbstractComponents());
                }
            });
        }
        if(CollectionUtils.isEmpty(abstractComponents) && CollectionUtils.isNotEmpty(components)) {
            abstractComponents.addAll(components);
        }
        //抽出规则
//        Integer statisticNum = null;
//        Optional<AgileDataBestShowRule> ruleOptional = bestShowRules.stream().filter(rule -> StringUtils.equals("STATISTIC_NUM",rule.getRuleType())).findFirst();
//        if(ruleOptional.isPresent()){
//            AgileDataBestShowRule rule = ruleOptional.get();
//            statisticNum = Integer.valueOf(rule.getRuleValue());
//        }
//        Integer echartsNum = null;
//        Optional<AgileDataBestShowRule> ruleEchartsOptional = bestShowRules.stream().filter(rule -> StringUtils.equals("ECHARTS_NUM",rule.getRuleType())).findFirst();
//        if(ruleEchartsOptional.isPresent()){
//            AgileDataBestShowRule rule = ruleEchartsOptional.get();
//            echartsNum = Integer.valueOf(rule.getRuleValue());
//        }
        //按组件类型分组
        Map<String, List<AbstractComponent>> abstractComponentMap = abstractComponents.stream().collect(Collectors.groupingBy(AbstractComponent::getType));
        //生成行
        List<AgileDataGridsterArrange> arranges = Lists.newArrayList();
        //按组件顺序生成结构

        for(String sort : sortComponent) {
            if(abstractComponentMap.containsKey(sort)){
                //计数器，每次只会取同一种类型，不用担心串用
//                int size = 0;
                //生成行
                AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
                // 组件防重添加标记,当前行继续添加元素时，无需另起一行
                Boolean isAdd = false;
                //每个组件生成一块区域
                for(AbstractComponent abstractComponent : abstractComponentMap.get(sort)) {
                    //区域初始化
                    AgileDataGridsterArea area = new AgileDataGridsterArea(abstractComponent,null);
                    //是否存在自定义指标，存在则覆盖默认区域坐标
                    GridGroupDTO userDefineGroup = getUserDefineGroup(userDefineLayout,abstractComponent.getId());
                    if(userDefineGroup != null){
                        area.setSize(userDefineGroup.getCols(),userDefineGroup.getRows());
                    } else {
                        area.setSize();
                    }
                    //分组初始化
                    AgileDataGridsterGroup agileDataGridsterGroup = new AgileDataGridsterGroup();
                    agileDataGridsterGroup.getAreas().add(area);
                    agileDataGridsterGroup.setSize();
                    //指标卡规则触发
//                    if(abstractComponent instanceof AgileDataIndexComponent){
//                        AgileDataIndexComponent agileDataIndexComponent = (AgileDataIndexComponent) abstractComponent;
//                        size = agileDataIndexComponent.getGroup().size() + size;
//                    } else {
//                        size ++;
//                    }
                    if(triggerRule(12,agileDataGridsterArrange,area)){
                        AgileDataGridsterArrange newArrange = getNewAgileDataGridsterArrange(agileDataGridsterGroup,arranges);
                        agileDataGridsterArrange = newArrange;
                        isAdd = true;
                        continue;
                    }
                    agileDataGridsterArrange.getGroups().add(agileDataGridsterGroup);
                    agileDataGridsterArrange.setSize();
                    if(!isAdd) {
                        arranges.add(agileDataGridsterArrange);
                    }
                    isAdd = true;
                }
            }
        }
        //获取最大宽高
        reSize(arranges);
        //输出items结构
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(area.getCols());
            gridGroupDTO.setRows(area.getRows());
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    /**
     * 查找自定义布局
     * @param userDefineLayout
     * @param defineId
     * @return
     */
    public static GridGroupDTO getUserDefineGroup(BoardLayoutMongoData userDefineLayout,String defineId){
        if(userDefineLayout == null){
            return null;
        }
        if(CollectionUtils.isEmpty(userDefineLayout.getBoardLayout())){
            return null;
        }
        return userDefineLayout.getBoardLayout().stream()
                .filter(gridGroup -> StringUtils.equals(gridGroup.getId(),defineId)).findFirst().orElse(null);
    }

    public static AgileDataGridsterArrange getNewAgileDataGridsterArrange(AgileDataGridsterGroup agileDataGridsterGroup,List<AgileDataGridsterArrange> arranges){
        AgileDataGridsterArrange newArrange = new AgileDataGridsterArrange();
        newArrange.getGroups().add(agileDataGridsterGroup);
        newArrange.setSize();
        arranges.add(newArrange);
        return newArrange;
    }

    public static List<GridGroupDTO> assembleGridster(List<AgileDataGridsterArrange> arranges){
        List<GridGroupDTO> gridGroupDTOList = Lists.newArrayList();
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(area.getCols());
            gridGroupDTO.setRows(area.getRows());
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static void reSize(List<AgileDataGridsterArrange> arranges){
        //获取最大宽高
        Optional<AgileDataGridsterArrange> arrangeOptional = arranges.stream().max(Comparator.comparing(AgileDataGridsterArrange::getWidth));
        if(arrangeOptional.isPresent()){
           AgileDataGridsterArrange maxArrange = arrangeOptional.get();
            //根据最大宽度，按比例适配最大宽度
            arranges.stream().forEach(arrange -> arrange.reSize(maxArrange.getWidth()));
            //补齐宽度
            arranges.stream().forEach(AgileDataGridsterArrange::completionSize);
            //计算坐标
            calcCoordinate(arranges);
        }
    }

    /**
     * 计算坐标
     * @param arranges
     */
    private static void calcCoordinate(List<AgileDataGridsterArrange> arranges) {
        //计算坐标
        int height = 0;
        for(AgileDataGridsterArrange arrange : arranges) {
            arrange.setCoordinate(height);
            height += arrange.getHeight();
        }
    }

    /**
     * 触发换行规则
     * @param num 阈值
     * @param agileDataGridsterArrange  当前行
     * @return
     */
    private static Boolean triggerRule(Integer num,AgileDataGridsterArrange agileDataGridsterArrange,AgileDataGridsterArea areaComponent){
        AtomicInteger totalCols = new AtomicInteger();
        agileDataGridsterArrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> totalCols.addAndGet(area.getCols())));

        //大于 阈值 ，生成新行
        if(totalCols.get() + areaComponent.getCols() > num){
            return true;
        }
        return false;
    }


}
