package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.ComponentDecimalRule;
import com.digiwin.athena.show.component.ComponentUnit;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;


public class ConvertAgileDataUtils {

    /**
     * 转换为uibot适配结构
     * @param agileReport
     * @param executeContext
     * @return
     */
//    public static TmActivity convert(AgileReport agileReport, ExecuteContext executeContext) {
//        TmActivity tmActivity = new TmActivity();
//        if(agileReport == null){
//            return null;
//        }
//        Map<String, TmQueryAction> dataSource = Maps.newHashMap();
//        List<TmDataState> dataStates = Lists.newArrayList();
//        //TmDataState
//        for(ThemeMapReport themeMapReport : agileReport.getReport()){
//            TmDataState tmDataState = new TmDataState();
//            AgileDataDefine agileDataDefine = new AgileDataDefine();
//            tmDataState.setAgileDataDefine(agileDataDefine);
//
//            TmActionBase tmActionBase = getDataSource(agileReport,themeMapReport.getDataSourceName());
//
//            agileDataDefine.setSceneTitle(themeMapReport.getTitle());
//            agileDataDefine.setSceneCode(executeContext.getTmActivityId());
//            agileDataDefine.setReportShow(themeMapReport.getReportShow());
//            agileDataDefine.setAppCode(themeMapReport.getAppCode());
//            agileDataDefine.setPageTurningFrequency(themeMapReport.getPageTurningFrequency());
//            agileDataDefine.setAgileDataRelation(themeMapReport.getAgileDataRelation());
//
//            //组装TmDataFilter
//            tmDataState.setDataFilter(buildFilter(themeMapReport,tmActionBase));
//            //组装submitaction
////            tmDataState.setSubmitActions(this.buildSubmitAction(themeMapReport,tmActionBase,executeContext));
//            //组装开窗
//            tmDataState.setOperations(buildOperations(themeMapReport,executeContext));
//            //echarts组件
//            agileDataDefine.setAgileReportECharts(themeMapReport.getECharts());
//            //settings
//            tmDataState.setSettings(buildSetting(themeMapReport));
//            //分页
//            tmDataState.setEnablePaging(themeMapReport.getEnablePaging());
//            //规则
//            agileDataDefine.setAgileRules(themeMapReport.getAgileRule());
//            //指标
//            agileDataDefine.setAgileReportIndex(themeMapReport.getAgileReportIndex());
//            //卡片
//            agileDataDefine.setAgileReportCard(themeMapReport.getCard());
//            //数据源
//            agileDataDefine.setTargetSource(themeMapReport.getDataSource());
//            dataStates.add(tmDataState);
//            //dataSource
//            dataSource.put(themeMapReport.getDataSourceName(),buildTmQueryAction(tmActionBase));
//        }
//        TmPage tmPage = new TmPage();
//        tmPage.setTitle(agileReport.getTitle());
//        tmPage.setDataStates(dataStates);
//        tmActivity.setPages(tmPage);
//        if(!AgileDataCheck.isScreen(executeContext)){
//            tmActivity.setPattern("DATA_ENTRY");
//        }
//        tmActivity.setDataSources(dataSource);
//        return tmActivity;
//    }




    private static JSONObject buildSetting(ThemeMapReport themeMapReport){
        Map<String,Object> titleMap = Maps.newHashMap();
        titleMap.put("tableTitle",themeMapReport.getTitle());
        Map<String,Object> map = Maps.newHashMap();
        map.put(themeMapReport.getDataSourceName(),titleMap);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(map);
        return jsonObject;
    }



    /**
     * 获取业务数据标识
     * @param snapDataDTO
     * @param actionId
     * @return
     */
    public static Map<String,Object> getDataTag(SnapDataDTO snapDataDTO, String actionId){
        Map<String, Object> businessMap = Maps.newHashMap();
        if(snapDataDTO != null && MapUtils.isNotEmpty(snapDataDTO.getPageData())) {
            List<Map<String, Object>> dataList = (List<Map<String, Object>>) snapDataDTO.getPageData().get(actionId);
            //获取业务类型
            List<Map<String, Object>> fields = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(dataList)) {
                Optional<Map<String, Object>> dataTagOptional = dataList.stream().filter(data -> data.containsKey("dataTag")).findFirst();
                if (dataTagOptional.isPresent()) {
                    Map<String, Object> dataMap = dataTagOptional.get();
                    if (MapUtils.isNotEmpty(dataMap) && dataMap.containsKey("dataTag")) {
                        Map<String, Object> dataTag = (Map<String, Object>) dataMap.get("dataTag");
                        if (dataTag.containsKey("fields")) {
                            fields = (List<Map<String, Object>>) dataTag.get("fields");
                        }
                    }
                }
            }
            //默认补齐规则
            if (!CollectionUtils.isEmpty(fields)) {
                businessMap = fields.stream()
                        .collect(Collectors.toMap(
                                map -> map.containsKey("field") ? map.get("field").toString() : "",
                                map -> map.containsKey("businessType") ? map.get("businessType").toString() : "",
                                (existingValue, newValue) -> existingValue // 如果遇到重复键，则保留旧值
                        ));
            }
        }
        return businessMap;
    }

    /**
     * 获取取舍对象
     * @param rule
     * @return
     */
    public static ComponentDecimalRule getDecimalRule(String rule){
        ComponentDecimalRule decimalRule = new ComponentDecimalRule();
        if(StringUtils.isNotEmpty(rule)){
            Integer roundValue = null;
            Boolean transABS = null;
            String roundMode = StringUtils.EMPTY;
            switch (rule){
                case "up":
                    roundMode = "up";
                    transABS = false;
                    break;
                case "down":
                    roundMode = "down";
                    transABS = false;
                    break;
                case "round":
                    roundMode = "round";
                    roundValue = 5;
                    transABS = false;
                    break;
                case "absUp":
                    roundMode = "up";
                    transABS = true;
                    break;
                case "absDown":
                    roundMode = "down";
                    transABS = true;
                    break;
                default:
                    break;
            }
            if(StringUtils.isNotEmpty(roundMode)) {
                decimalRule.setRoundValue(roundValue);
                decimalRule.setTransABS(transABS);
                decimalRule.setRoundMode(roundMode);
            }
        }
        return decimalRule;
    }

    /**
     * 获取取舍脚本
     * @param rule
     * @return
     */
    public static String getDecimalJS(String rule){
        StringBuilder jsString = new StringBuilder();
        if(StringUtils.isNotEmpty(rule)){
            Integer roundValue = null;
            Boolean transABS = null;
            String roundMode = StringUtils.EMPTY;
            switch (rule){
                case "up":
                    roundMode = "up";
                    transABS = false;
                    break;
                case "down":
                    roundMode = "down";
                    transABS = false;
                    break;
                case "round":
                    roundMode = "round";
                    roundValue = 5;
                    transABS = false;
                    break;
                case "absUp":
                    roundMode = "up";
                    transABS = true;
                    break;
                case "absDown":
                    roundMode = "down";
                    transABS = true;
                    break;
                default:
                    break;
            }
            if(StringUtils.isNotEmpty(roundMode)) {
                jsString.append("const decimalRule = { ");
                jsString.append(" roundMode: ");
                jsString.append("'");
                jsString.append(roundMode);
                jsString.append("'");
                jsString.append(",");
                if(transABS != null){
                    jsString.append(" transABS: ");
                    jsString.append(transABS);
                    jsString.append(",");
                }
                if(roundValue != null){
                    jsString.append(" roundValue: ");
                    jsString.append(roundValue);
                    jsString.append(",");
                }
                //删除最后一个多余的逗号
                jsString.deleteCharAt(jsString.lastIndexOf(","));
                jsString.append(" }; ");
            }
        }
        return jsString.toString();
    }

    /**
     * 获取单位对象
     * @param rule
     * @return
     */
    public static ComponentUnit getUnitRule(String rule){
        ComponentUnit componentUnit = new ComponentUnit();
        if(StringUtils.isNotEmpty(rule)){
            componentUnit.setType("metering");
            componentUnit.setValue(rule);
        }
        return componentUnit;
    }

    /**
     * 获取单位脚本
     * @param rule
     * @return
     */
    public static String getUnitJS(String rule){
        StringBuilder jsString = new StringBuilder();
        if(StringUtils.isNotEmpty(rule)){
            jsString.append("const unit = { ");
            jsString.append(" type: ");
            jsString.append("'metering'");
            jsString.append(",");
            jsString.append(" value: '");
            jsString.append(rule);
            jsString.append("'");
            jsString.append(" }; ");
        }
        return jsString.toString();
    }

    /**
     * 获取用户级模板编码
     * @param executeContext
     * @return
     */
    public static Boolean isNeedDefaultModel(ExecuteContext executeContext){
        Map<String,Object> agileData = executeContext.getAgileData();
        if(MapUtils.isEmpty(agileData)){
            return false;
        }
        if(!agileData.containsKey("screenModel")){
            return false;
        }
        return true;
    }



}
