package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.infrastructure.meta.ECHOConstants;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConvertGetAgileData {

    private ConvertGetAgileData() {
        throw new IllegalStateException("Utility class");
    }


    public static Map<String,MetadataField> getAgileData(String target,ApiMetadata apiMetadata){
        ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata(target,apiMetadata);
        ApiMetadataUtil.flatMetaData(masterApi);
        return ConvertGetAgileData.getFiledMap(target,masterApi);
    }

    /**
     * 获取业务数据
     * @param target
     * @param data
     * @return
     */
    public static List<Map<String,Object>> targetValue(String target,Object data){
        List<Map<String,Object>> dataList = Lists.newArrayList();
        Object obj = data;
        String[] paths = target.split(".");
        for(int i=0;i < paths.length;i++){
            if(obj instanceof Map) {
                Map<String,Object> bkMap = (Map<String, Object>) obj;
                obj = MapUtils.getObject(bkMap,paths[i]);
            } else if(obj instanceof Collection){
                List<Map<String,Object>> bkDataList = Lists.newArrayList();
                bkDataList.addAll( (List<Map<String, Object>>) obj);
                obj = bkDataList;
            }
        }
        if (obj instanceof Collection) {
            dataList.addAll((Collection<? extends Map<String, Object>>) obj);
        } else if (obj instanceof Map) {
            dataList.add((Map<String, Object>) obj);
        }
        return dataList;
    }

    public static ApiMetadata getMasterMetadata(String target, ApiMetadata apiMetadata){
        ApiMetadata masterMetadata;
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            masterMetadata = ApiMetadataUtil.getApiMetadataByMetaName(targetArray[0],apiMetadata);
        } else {
            masterMetadata = ApiMetadataUtil.getApiMetadataByMetaName(target,apiMetadata);
        }
        return masterMetadata;
    }

    public static Map<String, MetadataField> getFiledMap(String target, ApiMetadata masterApi){
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                masterMetadataMap = metadataField.getFieldMap();
            }
        } else {
            MetadataField metadataField = masterMetadataMap.get(target);
            masterMetadataMap = metadataField.getFieldMap();
        }
        return masterMetadataMap;
    }

    public static List<MetadataField> getTargetFiled(String target,ApiMetadata masterApi){
        List<MetadataField> fieldList = Lists.newArrayList();
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                masterMetadataMap = metadataField.getFieldMap();
            }
            if(MapUtils.isNotEmpty(masterMetadataMap)) {
                fieldList.addAll(masterMetadataMap.values());
            }
        } else {
            MetadataField metadataField = masterMetadataMap.get(target);
            fieldList = metadataField.getSubFields();
        }
        return fieldList;
    }

    public static Map<String,MetadataField> getFiledMasterMap(String target,ApiMetadata masterApi){
        Map<String,MetadataField> result = masterApi.getResponseFieldMap();
        Map<String,MetadataField> masterMetadataMap = masterApi.getResponseFieldMap();
        if(target.contains(".")){
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                MetadataField metadataField = masterMetadataMap.get(targetArray[i]);
                if(metadataField != null &&
                        ECHOConstants.DataType.OBJECT.equals(metadataField.getDataType())){
                    result.put(metadataField.getName(),metadataField);
                    masterMetadataMap = metadataField.getFieldMap();
                }
            }
        }
        return result;
    }

    public static List<MetadataField> getFiledList(String target,ApiMetadata masterApi){
        List<MetadataField> filedList = Lists.newArrayList();

        if(target.contains(".")){
            MetadataField metadataField = null;
            String[] targetArray = target.split("\\.");
            for(int i =0;i < targetArray.length;i++){
                if(metadataField == null) {
                    metadataField = masterApi.getResponseFieldMap().get(targetArray[i]);
                    continue;
                }
                metadataField = metadataField.getFieldMap().get(targetArray[i]);
            }
            filedList.add(metadataField);
        } else {
            filedList = masterApi.getResponseFields();
        }
        return filedList;
    }

    /**
     * 获取指定类型字段
     * @param target
     * @param apiMetadata
     * @param contains 是否满足 true满足，false不满足
     * @return
     */
    public static List<MetadataField> getStringField(String type,String target,ApiMetadata apiMetadata,Boolean contains){
        List<MetadataField> stringMetadataFields = Lists.newArrayList();
        if(apiMetadata == null){
            return stringMetadataFields;
        }
        ApiMetadataUtil.flatMetaData(apiMetadata);
        List<MetadataField> metadataFields = ConvertGetAgileData.getTargetFiled(target,apiMetadata);
        if(CollectionUtils.isNotEmpty(metadataFields)){
            metadataFields.stream().forEach(metadataField -> {
                if(contains){
                    if(StringUtils.equals(type,metadataField.getDataType())){
                        stringMetadataFields.add(metadataField);
                    }
                } else {
                    if(!StringUtils.equals(type,metadataField.getDataType())){
                        stringMetadataFields.add(metadataField);
                    }
                }

            });
        }
        return stringMetadataFields;
    }

    /**
     * 从元数据中获取字段信息，若字段不存在，则进行模糊匹配
     * @param target
     * @param apiMetadata
     * @param field
     * @return
     */
    public static String getApiFiled(String target,ApiMetadata apiMetadata,String field){
        String findField = "";
        //获取到元数据业务字段信息
        ApiMetadataUtil.flatMetaData(apiMetadata);
        List<MetadataField> metadataFields = getTargetFiled(target,apiMetadata);
        //匹配字段是否存在
        Optional<MetadataField> optFindField = metadataFields.stream().filter(metadataField -> StringUtils.equals(field,metadataField.getName())).findFirst();
        //不存在，则进行模糊匹配，使用元数据字段
        if(!optFindField.isPresent()){
            for(MetadataField metadataField : metadataFields) {
                if(field.contains(metadataField.getName())){
                    findField = metadataField.getName();
                }
            }
        } else {
            findField = field;
        }
        return findField;
    }

    public static String getRootFiled(ApiMetadata apiMetadata){
        String findField = "";
        //获取到元数据业务字段信息
        List<MetadataField> metadataFields = apiMetadata.getResponseFields();
        if(CollectionUtils.isNotEmpty(metadataFields)){
            for(MetadataField metadataField : metadataFields){
                if(metadataField.isObjectField()){
                    findField = metadataField.getName();
                    break;
                }
            }
        }
        return findField;
    }

    public static MetadataField getRootMetadataField(ApiMetadata apiMetadata){
        MetadataField objectMetadataField = new MetadataField();
        //获取到元数据业务字段信息
        List<MetadataField> metadataFields = apiMetadata.getResponseFields();
        if(CollectionUtils.isNotEmpty(metadataFields)){
            for(MetadataField metadataField : metadataFields){
                if(metadataField.isObjectField()){
                    objectMetadataField = metadataField;
                    break;
                }
            }
        }
        return objectMetadataField;
    }


}
