package com.digiwin.athena.show.domain.agileDataDTO;

import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.enums.FieldTypeEnum;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 移动端中间态展现形式
 */
@Data
public class MobileDSLChartRender {

    /**
     * 图表类型
     */
    private String chartType;

    /**
     * 标题
     */
    private String title;

    /**
     * 呈现说明字段
     */
    private List<Point> points;

    /**
     * 呈现数据字段
     */
    private List<DSLChartValue> values;

    /**
     * 度量呈现方式
     */
    private List<MobileDSLChartMeasure> measurePresents;

    /**
     * 参考线
     */
    private Map<String,Object> markLine;



    /**
     * 堆叠字段
     */
    private String stackGroupField;

    @Data
    public static class DSLChartValue{
        private String name;
        private String title;
        private FieldTypeEnum dataType;
        private Map<String,Object> format;
        private String chartType;
        private String description;
        private String businessType;
        private Integer group;
    }

}
