package com.digiwin.athena.show.domain.board;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class BoardLayoutParamsDTO {

    /**
     * 助理ID
     */
    private String assistantId;

    /**
     * sessionId
     */
    private String conversationId;

    /**
     * 消息体
     */
    private Message message;

    @Data
    public static class Message {

        /**
         * 文本输入的内容
         */
        private String content;

        /**
         * 多模态（文本、图片）输入内容
         */
        private List<Attachment> attachments;

        /**
         * 引用消息的MessageId - 2.0 第一版用不到
         */
        private String replyId;

        /**
         * 沿用 1.0 入参
         */
        private Map<String,Object> extData;

        @Data
        public static class Attachment {

            /**
             * 多模态消息内容类型，支持设置为：
             * - file：文件类型。
             * - image：图片类型。
             */
            private String type;

            /**
             * 文件、图片内容的 DMC ID。bucket 为Athena
             */
            private String fileId;

            /**
             * 数据库
             */
            private String bucket;

            /**
             * 文件、图片 内容的文件名称
             */
            private String fileName;

            /**
             * 文件、图片 内容的文件后缀
             */
            private String fileType;
        }
    }

}
