package com.digiwin.athena.show.domain.showDefine;

import org.apache.commons.lang.StringUtils;

/**
 * 敏数业务类型
 */
public enum AgileDataBusinessEnum {
    //金额
    AMOUNT("amount",1),
    //单价
    UNIT_PRICE("unitPrice",2),
    //数量
    QUANTITY("Quantity",3),
    //天数
    DAYS("days",4),
    //比率
    RATE("Rate",5);



    private String businessType;

    private Integer level;

    private AgileDataBusinessEnum(String businessType,Integer level) {
        this.businessType = businessType;
        this.level = level;
    }

    /**
     * 获取级别
     * @param businessType
     * @return
     */
    public static Integer getBusinessType(String businessType) {
        for(AgileDataBusinessEnum businessEnum : AgileDataBusinessEnum.values()){
            if(businessType.equals(businessEnum.businessType)){
                return businessEnum.level;
            }
        }
        return null;
    }

    /**
     * 是否为金额类业务类型
     * @param businessType
     * @return
     */
    public static Boolean isAmountType(String businessType) {
        if(StringUtils.isEmpty(businessType)){
            return false;
        }
        if(StringUtils.equals(AgileDataBusinessEnum.AMOUNT.businessType, businessType)){
            return true;
        }
        if(StringUtils.equals(AgileDataBusinessEnum.UNIT_PRICE.businessType, businessType)){
            return true;
        }
        return false;
    }


}
