package com.digiwin.athena.show.domain.showDefine;

import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeDTO;
import com.digiwin.athena.show.domain.agileDataDTO.SceneDTO;
import lombok.Data;

import java.util.List;


/**
 * km呈现定义
 */
@Data
public class AgileReportKMData {

    /**
     * 场景标题
     */
    private String sceneTitle;

    /**
     * 场景信息
     */
    private SceneDTO scene;

    /**
     * 大屏刷新周期 分钟
     */
    private Integer flashFrequency;

    /**
     * 数据流刷新频率
     */
    private Integer pageTurningFrequency;

    /**
     * 展示信息
     */
    private List<AgileReportShowTypeDTO> showType;

    /**
     * 敏捷数据定义
     */
    private List<AgileReportShow> show;

    /**
     * 数据源
     */
    private String actionId;

    /**
     * 场景code
     */
    private String code;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 数据关系
     */
    private List<AgileDataRelationDTO> actionRelation;

    /**
     * 大屏布局ID
     */
    private String layoutId;

}
