package com.digiwin.athena.show.infrastructure.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class ECHOConstants {

    public static final List<String> ACTION_LIST = Arrays.asList("dispatch", "reexecute", "agree", "disagree", "reassign", "reapprove", "add-task", "terminate-task");

    public static final String cacheKeyPrefix = "uibot:cache:";

    public static final String atdmCacheKeyPrefix = "atdm:cache:";

    /**
     * ESP服务类别
     */
    public static final String DATA_SOURCE_DATA_KEY = "__DATA_KEY";

    /**
     * 曲线图
     */
    public static final String LINE = "line";




    public static class DataType {

        private DataType() {
        }

        public static final String OBJECT = "object";

        public static final String STRING = "string";

        public static final String ARRAY = "array";

        public static final String DATE = "date";

        public static final String DATETIME = "datetime";

        public static final String TIME = "time";

        public static final String NUMBER = "number";

        public static final String NUMERIC = "numeric";

        public static final String BOOLEAN = "boolean";

        /**
         * 获取初始化数据的时候（如：基础资料录入双档类型作业的新增子页签界面，新增数据时，要根据元数据定义返回初始化数据给前端）要将值初始化为null值的数据类型列表
         *
         * @return 不可修改的List集合实例
         */
        public static List<String> getToNullDataTypes() {
            return Collections.unmodifiableList(Arrays.asList(NUMBER, NUMERIC, BOOLEAN, DATE, DATETIME, TIME));
        }

    }

    public static class ComponentType {

        private ComponentType() {
        }

        public static final String ECHARTS = "ECHARTS";

        public static final String ATTACHMENT = "ATTACHMENT";

        public static final String DESCRIPTION = "DESCRIPTION";

        public static final String CONTENT_TITLE = "CONTENT_TITLE";

        public static final String MANUAL_CREATE_TASK = "MANUAL_CREATE_TASK";

        public static final String NAVIGATE_REPORT = "NAVIGATE_REPORT";

        public static final String NAVIGATE_TASK = "NAVIGATE_TASK";

        public static final String NAVIGATE_TO_TASK = "NAVIGATE_TO_TASK";

        public static final String PLAN_SELECT = "PLAN_SELECT";


        public static final String GROUP_INLINE = "GROUP_INLINE";

        public static final String FORM_LIST = "FORM_LIST";

        public static final String SELECT_ROW_DETAIL = "SELECT_ROW_DETAIL";

        public static final String SPLIT_LAYOUT = "SPLIT_LAYOUT";

        public static final String FORM_ITEM = "FORM_ITEM";

        public static final String FLEX_LIST = "FLEX";

        public static final String GRIDSTER = "GRIDSTER";

        public static final String TABS = "TABS";

        public static final String DRAWER_BUTTON = "DRAWER_BUTTON";

        public static final String TOOLBAR = "TOOLBAR";

        public static final String TABLE = "TABLE";

        public static final String ATHENA_TABLE = "ATHENA_TABLE";

        public static final String ACTIVITY_TITLE = "ACTIVITY_TITLE";
        public static final String TASK_DISTRIBUTION_EXCEPTION_HANDLING = "TASK_DISTRIBUTION_EXCEPTION_HANDLING";

        public static final String TREE_DATA = "TREEDATA";

        public static final String LAYOUT = "LAYOUT";

        public static final String WORKFLOW_PROGRESS = "WORKFLOW_PROGRESS";

        public static final String CONTENT_QUERY_BUTTON = "CONTENT_QUERY_BUTTON";
        public static final String BUTTON = "BUTTON";

        public static final String SIGN_OFF_PROGRESS_LINK = "SIGN_OFF_PROGRESS_LINK";

        public static final String DELIVERY_REPLY_TITLE = "DELIVERY_REPLY_TITLE";

        public static final String DELIVERY_REPLY_DESCRIPTION = "DELIVERY_REPLY_DESCRIPTION";

        public static final String APPROVAL_DESCRIPTION = "APPROVAL_DESCRIPTION";

        public static final String DATA_UNIFORMITY_HISTORY = "DATA_UNIFORMITY_HISTORY";

        // 数据视图组件
        public static final String DATA_VIEW_QUERY = "DATA_VIEW_QUERY";

        public static final String LABEL = "LABEL";

        public static final String TEXTAREA = "TEXTAREA";

        public static final String DATEPICKER = "DATEPICKER";

        public static final String TIMEPICKER = "TIMEPICKER";

        public static final String CHECKBOX = "CHECKBOX";

        public static final String EOC_SELECT = "EOC_SELECT";

        public static final String NAME_CODE_COMPONENT = "NAME_CODE_COMPONENT";

        public static final String NEW_OLD_COMPONENT = "NEW_OLD_COMPONENT";

        public static final String FLEXIBLE_BOX = "FLEXIBLE_BOX";

        public static final String ADD_DOCUMENTID_CONTROL = "ADD_DOCUMENTID_CONTROL";

        public static final String ATH_TAG = "ATH_TAG";

        public static final String SELECT = "SELECT";

        public static final String EMPTY = "EMPTY";
        public static final String OUTLET = "OUTLET";
        public static final String DATA_QUERY = "DATA_QUERY";


        public static final String MULTIPLE_SELECT = "MULTIPLE_SELECT";

        public static final String RADIO_GROUP = "RADIO_GROUP";

        public static final String INPUT = "INPUT";

        public static final String EOC_MULTI_SELECT = "EOC_MULTI_SELECT";

        public static final String EOC_SINGLE_SELECT = "EOC_SINGLE_SELECT";

        public static final String EOC_USER_SELECT = "EOC_USER_SELECT";

        public static final String MULTI_EOC_SELECT = "MULTI_EOC_SELECT";

        public static final String AMOUNT_INPUT = "AMOUNT_INPUT";

        public static final String D_ARRAY = "D_ARRAY";

        public static final String ARRAY = "ARRAY";

        public static final String TASK_FILE_UPLOAD = "TASK_FILE_UPLOAD";

        public static final String TASK_FORM_UPLOAD = "TASK_FORM_UPLOAD";

        public static final String FILE_UPLOAD = "FILE_UPLOAD";

        public static final String FORM_UPLOAD = "FORM_UPLOAD";

        public static final String BASE_DATA_MANAGER_STATUS = "BASE_DATA_MANAGER_STATUS";

        public static final String COMBINATION_CHART = "COMBINATION_CHART";

        public static final String COLLAPSE_AND_EXPAND = "COllAPSE_AND_EXPAND";

        public static final String MEASURE = "MEASURE";

        public static final String PERCENT_INPUT = "PERCENT_INPUT";

        public static final String PERCENT_LABEL = "PERCENT_LABEL";

        public static final String HOVERLABEL = "HOVERLABEL";

        public static final String OPERATION_EDITOR = "OPERATION_EDITOR";

        public static final String FORM_OPERATION_EDITOR = "FORM_OPERATION_EDITOR";

        public static final String COLLAPSE_PANEL = "COLLAPSE";

        public static final String PERSON_SELECT = "PERSON_SELECT";

        //public static final String WBS_CARD = "WBS_CARD";

        public static final String STATISTIC = "STATISTIC";

        public static final String SIGN_OFF_PROGRESS = "SIGN_OFF_PROGRESS";

        public static final String DATE_RANGE = "DATE_RANGE";

        public static final String LIST = "LIST";
        public static final String TEXT = "TEXT";
        public static final String MILESTONE = "MILESTONE";
        public static final String FLEX = "FLEX";
        public static final String CARD = "CARD";

        //密码输入框组件
        public static final String PASSWORD = "PASSWORD";
        /**
         * 克隆组件
         */
        public static final String DUPLICATION_CONTAINER = "DUPLICATION_CONTAINER";

        public static final String TEXT_GROUP = "TEXT_GROUP";

        public static final String BUTTON_PRINT = "BUTTON_PRINT";

        public static final String OPERATION_PRINT = "print";

        public static final String OPERATION_ACTION_PRINT = "ATMC_PRINT";


        /**
         * 退回信息
         */
        public static final String SIGN_OFF_RETURN_INFO = "SIGN_OFF_RETURN_INFO";
        public static final String DYNAMIC_GRAPH_VIEWER = "DYNAMIC_GRAPH_VIEWER";

        public static final String BUTTON_GROUP = "BUTTON_GROUP";

        //BUTTON组件开始
        public static final String BUTTON_DATA_DELETE = "BUTTON_DATA_DELETE";
        public static final String BUTTON_RECYCLE_DELETE = "BUTTON_RECYCLE_DELETE";
        public static final String BUTTON_DELETE_TO_RECYCLE = "BUTTON_DELETE_TO_RECYCLE";
        public static final String BUTTON_DATA_DELETEALL = "BUTTON_DATA_DELETEALL";
        public static final String BUTTON_DATA_SAVE = "BUTTON_DATA_SAVE";
        public static final String BUTTON_DATA_COMBINE_SAVE = "BUTTON_DATA_COMBINE_SAVE";
        public static final String BUTTON_DATA_UPDATE = "BUTTON_DATA_UPDATE";
        public static final String BUTTON_DATA_INVALID = "BUTTON_DATA_INVALID";
        public static final String BUTTON_SUB_PAGE = "BUTTON_SUB_PAGE";
        public static final String BUTTON_DATA_VALID = "BUTTON_DATA_VALID";
        public static final String BUTTON_DATA_RECOVER = "BUTTON_DATA_RECOVER";
        public static final String BUTTON_WORKFLOW_INVOKE = "BUTTON_WORKFLOW_INVOKE";
        public static final String BUTTON_WORKFLOW_ABORT = "BUTTON_WORKFLOW_ABORT";
        public static final String BUTTON_SUBMIT_ACTION = "BUTTON_SUBMIT_ACTION";

        // SSO免登按钮组件
        public static final String BUTTON_JUMP = "BUTTON_JUMP";
        //BUTTON组件结束

        //Operation BUTTON组件开始
        public static final String BUTTON_UPLOAD_FILE = "BUTTON_UPLOAD_FILE";
        public static final String BUTTON_DOWNLOAD_TEMPLATE = "BUTTON_DOWNLOAD_TEMPLATE";
        public static final String BUTTON_DRAWINGS_DOWNLOAD = "BUTTON_DRAWINGS_DOWNLOAD";
        public static final String BUTTON_BATCH_SET_DATE = "BUTTON_BATCH_SET_DATE";
        public static final String BUTTON_OPERATE_SCRIPT = "BUTTON_OPERATE_SCRIPT";
        public static final String BUTTON_SPLIT_ROW = "BUTTON_SPLIT_ROW";
        public static final String BUTTON_AUTO_SPLIT_ROW = "BUTTON_AUTO_SPLIT_ROW";

        public static final String BUTTON_ADD_ITEM = "BUTTON_ADD_ITEM";
        public static final String BUTTON_DELETE_ITEM = "BUTTON_DELETE_ITEM";
        public static final String BUTTON_BATCH_DELETE_ITEM = "BUTTON_BATCH_DELETE_ITEM";
        public static final String BUTTON_FRONT_EXPORT = "BUTTON_FRONT_EXPORT";
        public static final String BUTTON_BACKEND_EXPORT = "BUTTON_BACKEND_EXPORT";
        public static final String BUTTON_TOOLBAR_EDIT = "BUTTON_TOOLBAR_EDIT";
        public static final String BUTTON_TOOLBAR_PREVIOUS = "BUTTON_TOOLBAR_PREVIOUS";
        public static final String BUTTON_TOOLBAR_NEXT = "BUTTON_TOOLBAR_NEXT";
        public static final String BUTTON_COPY_ITEM = "BUTTON_COPY_ITEM";
        public static final String BUTTON_OPENPAGE_ADD = "BUTTON_OPENPAGE_ADD";
        public static final String BUTTON_OPENPAGE_EDIT = "BUTTON_OPENPAGE_EDIT";
        public static final String BUTTON_OPENPAGE_COPY = "BUTTON_OPENPAGE_COPY";

        //Operation BUTTON组件结束

        public static final String DIVIDER = "DIVIDER";
        public static final String IMAGE = "IMAGE";
        public static final String ICON = "ICON";

        public static final String ALERT = "ALERT";

        public static final String SCANNER_GUN_ANALYSIS = "SCANNER_GUN_ANALYSIS";

        public static final String BUTTON_IMPORT = "BUTTON_IMPORT";

        public static final String BUTTON_CLOSE = "BUTTON_CLOSE";

        public static final String EOC_MULTI_SELECT_NEW = "EOC_MULTI_SELECT_NEW";

        public static final String EOC_SELECT_NEW = "EOC_SELECT_NEW";

        public static final String EOC_USER_SELECT_NEW = "EOC_USER_SELECT_NEW";

        public static final String PERSON_SELECT_NEW = "PERSON_SELECT_NEW";

    }


}
