package com.digiwin.athena.show.manager.themeMap.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ThemeAgileDataServiceImpl implements ThemeAgileDataService {

    private final Logger logger = LoggerFactory.getLogger(ThemeAgileDataServiceImpl.class);

    @Autowired
    private EchoEnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;


    @Override
    public AgileReportKMData querySceneMaps(String code) {
        String url = envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/querySceneMaps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        Map<String, Object> sceneMap = Maps.newHashMap();
        sceneMap.put("code", code);
        HttpEntity<Map> requestEntity = new HttpEntity<>(sceneMap, headers);
        try {
            ResponseEntity<BaseResultDTO<AgileReportKMData>> responseEntity = restTemplate.exchange(url
                    , HttpMethod.POST
                    , requestEntity
                    , new ParameterizedTypeReference<BaseResultDTO<AgileReportKMData>>() {
                    }
                    , sceneMap);
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            String message = messageUtils.getMessage("exception.agiledata.scenced.error");
            throw BusinessException.create(message);
        }
    }

    @Override
    public List<AgileDataRelationDTO> queryActionRelation(List<String> actionIds) {
        String url = envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/queryActionRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        Map<String, Object> relationMap = Maps.newHashMap();
        relationMap.put("actionIds", actionIds);
        HttpEntity<Map> requestEntity = new HttpEntity<>(relationMap, headers);
        try {
            ResponseEntity<BaseResultDTO<List<AgileDataRelationDTO>>> responseEntity = restTemplate.exchange(url
                    , HttpMethod.POST
                    , requestEntity
                    , new ParameterizedTypeReference<BaseResultDTO<List<AgileDataRelationDTO>>>() {
                    }
                    , relationMap);
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public List<AgileReportKMData> querySceneMapsByActionId(List<String> actionIds) {
        String url = envProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/queryActionReportConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        Map<String, Object> sceneMap = Maps.newHashMap();
        sceneMap.put("actionIds", actionIds);
        HttpEntity<Map> requestEntity = new HttpEntity<>(sceneMap, headers);
        try {
            ResponseEntity<BaseResultDTO<List<AgileReportKMData>>> responseEntity = restTemplate.exchange(url
                    , HttpMethod.POST
                    , requestEntity
                    , new ParameterizedTypeReference<BaseResultDTO<List<AgileReportKMData>>>() {
                    }
                    , sceneMap);
            return responseEntity.getBody().getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public String findLastNodeShapeType(Map<String, Object> chartParams) {
        String url = envProperties.getKnowledgeMapsUrl() + "knowledgegraph/Action/findLastNodeShapeType";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());

        HttpEntity httpEntity = new HttpEntity<Map>(chartParams, headers);
        try {
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
            Map result = responseEntity.getBody();
            if (result.containsKey("response")) {
                return MapUtils.getString(result, "response");
            } else {
                return null;
            }
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    /**
     * 查看看板信息
     * @param boardId
     * @return
     */
    @Override
    public ThemeMapBoardDTO getThemeMapBoard(String boardId) {
        String url = envProperties.getKnowledgeMapsUrl() + "knowledgegraph/dataBoard/queryBoardById";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        Map<String, Object> params = Maps.newHashMap();
        params.put("boardId",boardId);
        HttpEntity httpEntity = new HttpEntity<Map>(params, headers);
        try {
            ResponseEntity<BaseResultDTO<ThemeMapBoardDTO>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<ThemeMapBoardDTO>>() {
                    });
            log.info("获取看板信息返参：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    /**
     * 查看看板问题信息
     * @param questionId
     * @return
     */
    @Override
    public ThemeMapBoardDTO.DataBoardQuestion getThemeMapBoardQuestion(String questionId) {
        String url = envProperties.getKnowledgeMapsUrl() + "/restful/service/knowledgegraph/dataBoard/queryDataBoardConfig";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        headers.add("token", getToken());
        Map<String, Object> params = Maps.newHashMap();
        params.put("questionId",questionId);
        HttpEntity httpEntity = new HttpEntity<Map>(params, headers);
        try {
            ResponseEntity<BaseResultDTO<ThemeMapBoardDTO.DataBoardQuestion>> response = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<ThemeMapBoardDTO.DataBoardQuestion>>() {
                    });
            log.info("获取看板问题信息返参：{}", JsonUtils.objectToString(response.getBody().getResponse()));
            return response.getBody().getResponse();
        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            return null;
        }
    }

    private String getToken() {
        if (null != AppAuthContextHolder.getContext().getProxyAuthoredUser()) {
            return AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken();
        } else {
            return AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        }
    }
}
