package com.digiwin.athena.show.service;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 敏数通用定义
 */
@Service
public class AgileDataGeneralThemeMapDefine extends AgileDataThemeMapDefine {

    @Override
    public String supportKey() {
        return SUPPORT_KEY_PREFIX + "0";
    }

    /**
     * 构建大屏定义
     * @param agileReportKMData
     * @param executeContext
     */
    public void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        return;
    }

    @Override
    public Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        switch (judgeCode){
            case "metadata":
                if (apiMetadata == null) {
                    return true;
                }
                break;
            case "agileData":
                if(!checkPageData(agileDataListList)) {
                    return true;
                }
                break;
            case "target":
                if(targetDTO == null) {
                    return true;
                }
                break;
            case "pageData":
                if (CollectionUtils.isEmpty(pageData)) {
                    return true;
                }
                break;
            default:
                return false;
        }
        return false;
    }


    private boolean checkPageData(List<Map<String, Object>> agileDataListList) {
        if (CollectionUtils.isEmpty(agileDataListList)) {
            return false;
        }
        for (Map<String, Object> agileMap : agileDataListList) {
            if (!agileMap.containsKey("data")) {
                return false;
            }
        }
        return true;
    }
}
