package com.digiwin.athena.show.service;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentBody;
import com.digiwin.athena.show.component.AbstractComponentHeader;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponent;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponentImpl;
import com.digiwin.athena.show.component.panel.PanelComponent;
import com.digiwin.athena.show.component.panel.PanelComponentImpl;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service
public class AgileDataScreenPageTemplate extends AgileReportPageTemplate {

    @Autowired
    private PanelComponentImpl panelComponentImpl;

    @Autowired
    private LabelTitleComponentImpl labelTitleComponent;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public String supportKey() {
        return "AGILE_DATA_TEMPLATE_SCREEN";
    }

    @Override
    protected List<AgileDataBestShowRule> getBestShowRules(ExecuteContext executeContext) {
        return Lists.newArrayList();
    }



    @Override
    protected AbstractComponent createNoneDataComponent(ThemeMapReport themeMapReport, ExecuteContext executeContext, DynamicAgileData dynamicAgileData) {
        //非大屏空数据会被拦截，无需再次进行无数据呈现
        if (!AgileDataCheck.isScreen(executeContext)) {
            return null;
        }
        if (isEmptyData(themeMapReport)) {
            //标题通过白板构建
            PanelComponent panelComponent = (PanelComponent) panelComponentImpl.initComponent(new MetadataField(),null);
            panelComponent.setId(themeMapReport.getActionId());
            AbstractComponentHeader header = new AbstractComponentHeader();
            if (StringUtils.isNotEmpty(themeMapReport.getTitle())) {
                header.setTitle(themeMapReport.getTitle());
                header.setTitlePosition("left");
            }
            //提示内容通过label构建
            LabelTitleComponent titleComponent = (LabelTitleComponent) labelTitleComponent.initComponent(new MetadataField(),null);
            titleComponent.setId(themeMapReport.getActionId() + "_label");
            AbstractComponentBody body = new AbstractComponentBody();
            body.setGroup(Arrays.asList(titleComponent));
            panelComponent.setBody(body);
            panelComponent.setHeader(header);
            //兼容前端数据结构
            Map<String, Object> data = Maps.newHashMap();
            data.put(titleComponent.getTitle(), messageUtils.getMessage("exception.agileReport.screen.empty.data"));
            return panelComponent;
        }
        return null;
    }

    private boolean isEmptyData(ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty(themeMapReport.getPageData())) {
            return true;
        }
        if (themeMapReport.getApiMetadata() == null) {
            return true;
        }
        Optional<MetadataField> metadataField = themeMapReport.getApiMetadata().getResponseFields().stream().filter(field -> field.isObjectField() && CollectionUtils.isEmpty(field.getSubFields())).findFirst();
        if (metadataField.isPresent()) {
            return true;
        }
        return false;
    }
}
