package com.digiwin.athena.show.service;

import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataFilter;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenModel;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 敏数大屏定义
 */
@Service
public class AgileDataScreenThemeMapDefine extends AgileDataThemeMapDefine{

    @Autowired
    private AdtService adtService;

    @Autowired
    private StringRedisTemplate redisTemplate;

    private static final String keyPrefix = "adt:cache:AGILEDATA_SCREEN_";


    @Override
    public String supportKey() {
        return SUPPORT_KEY_PREFIX + "1";
    }

    @Override
    public void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
        if(StringUtils.isNotEmpty(agileReportKMData.getLayoutId())){
            AgileDataScreenModel agileDataScreenModel;
            String models = redisTemplate.opsForValue().get(keyPrefix + agileReportKMData.getLayoutId());
            if(StringUtils.isNotEmpty(models)){
                agileDataScreenModel = JsonUtils.jsonToObject(models, AgileDataScreenModel.class);
            } else {
                agileDataScreenModel = adtService.getAgileDataScreenModel(agileReportKMData.getLayoutId(), executeContext.getLocale());
                if(agileDataScreenModel != null) {
                    redisTemplate.opsForValue().set(keyPrefix + agileReportKMData.getLayoutId(), JsonUtils.objectToString(agileDataScreenModel));
                }
            }
            if(agileDataScreenModel != null) {
                String screenActionIds = agileReportKMData.getActionId();
                List<String> filterActionId = Lists.newArrayList();
                executeContext.getAgileData().put("screenModel", agileDataScreenModel);
                agileReportKMData.getShowType().stream().forEach(showType -> showType.getType().stream().forEach(type -> {
                    if(!CollectionUtils.isEmpty(type.getFilter())){
                        filterActionId.addAll(type.getFilter().stream().map(AgileDataFilter::getActionId).collect(Collectors.toList()));
                    }
                }));
                if(!CollectionUtils.isEmpty(filterActionId)){
                    List<String> actionIds = Lists.newArrayList(Arrays.asList(agileReportKMData.getActionId().split(",")));
                    actionIds.removeAll(filterActionId);
                    screenActionIds = String.join(",", actionIds);
                }
                executeContext.getAgileData().put("screenActionIds", screenActionIds);
            }
        }
    }

    @Override
    public Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return false;
    }

}
