package com.digiwin.athena.show.util;

import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Map;

@Slf4j
public class ClassResourceUtil {

    public static String readFile(String resourcePath) throws Exception {

        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (classPathResource.exists()) {
            InputStream inputStream = classPathResource.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader br = new BufferedReader(reader);
            String s = "";
            StringBuffer content = new StringBuffer();
            while ((s = br.readLine()) != null) {
                content = content.append(s);
            }
            br.close();

            return content.toString();
        } else {
            return null;
        }
    }

    /**
     * 获取mock数据
     *
     * @param mockFileName
     * @return
     * @throws Exception
     */
    public static Map getMockData(String mockFileName) throws Exception {
        String path = MessageFormat.format("/mock/test/{0}.json", mockFileName);
        if (StringUtils.isNotEmpty(path)) {
            String result = ClassResourceUtil.readFile(path);
            return JsonUtils.jsonToObject(result, Map.class);
        }
        return null;
    }

    /**
     * @param target
     * @param fieldName
     * @param value
     */
    public static void setInternalState(Object target, String fieldName, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);//暴力的改成可访问，不管现有的修饰
            field.set(target, value);
        } catch (Exception e) {

        }
    }

}
