/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.EchoSchemaElReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoSchemaElService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/echo/schema"})
public class EchoSchemaElementController {
    @Autowired
    private EchoSchemaElService echoSchemaElService;

    @PostMapping(value={"/submit"})
    public ResponseEntity<?> submit(@RequestBody @Validated EchoSchemaElReqDTO reqDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.echoSchemaElService.submit(reqDTO, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/queryInfo/{messageId}"})
    public ResponseEntity<?> getExceptionInfoByMessageId(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoSchemaElService.getSchemaElInfoByMessageId(messageId, user));
    }

    @GetMapping(value={"/getInfoAndSchema/{messageId}"})
    public ResponseEntity<?> getInfoAndSchema(@PathVariable(value="messageId") String messageId, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoSchemaElService.getInfoAndSchema(messageId, user));
    }
}

