/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.ade.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.ade.AgileDataEngineService;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineAnalysisModel;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineFileDownModel;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AgileDataEngineServiceImpl
implements AgileDataEngineService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataEngineServiceImpl.class);
    @Autowired
    private EchoEnvProperties echoEnvProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${appToken:}")
    private String appToken;

    public AgileDataEngineFileDownModel getFileDownUrl(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = this.echoEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/download/detail";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6\u4e0b\u8f7d\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString(params));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u4e0b\u8f7d\u4fe1\u606f\u7ed3\u679c\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (AgileDataEngineFileDownModel)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_GET_FILE_URL_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public AgileDataEngineAnalysisModel getAnalysisData(AuthoredUser user, Map<String, Object> params, String locale) {
        String url = this.echoEnvProperties.getAdeUri() + "/restful/standard/AgileDataEngine/instant/getEssentialFactor";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", user.getToken());
        headers.add("routerKey", user.getTenantId());
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            log.info("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString(params));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u83b7\u53d6\u89e3\u6790\u7ed3\u679c\u96c6\uff1a{}", (Object)JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            return (AgileDataEngineAnalysisModel)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.ADE_GET_ANALYSIS_URL_FAIL.getErrCode(), url, user.getToken(), user.getTenantId(), e.getMessage()});
            return null;
        }
    }
}

