/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.digiwin.athena.agiledataecho.constant.CommonConstants;
import com.digiwin.athena.agiledataecho.dao.EchoSchemaElLogMapper;
import com.digiwin.athena.agiledataecho.domain.EchoSchemaElementLog;
import com.digiwin.athena.agiledataecho.dto.EchoInformationResDTO;
import com.digiwin.athena.agiledataecho.dto.EchoSchemaEIResDTO;
import com.digiwin.athena.agiledataecho.dto.EchoSchemaElReqDTO;
import com.digiwin.athena.agiledataecho.proxy.iam.UserService;
import com.digiwin.athena.agiledataecho.service.AbsEchoService;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.agiledataecho.service.EchoSchemaElService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EchoSchemaElServiceImpl
extends AbsEchoService
implements EchoSchemaElService {
    private static final Logger log = LoggerFactory.getLogger(EchoSchemaElServiceImpl.class);
    @Autowired
    private EchoInformationService echoInformationService;
    @Resource
    private EchoSchemaElLogMapper echoSchemaElLogMapper;
    @Autowired
    private UserService userService;

    public void submit(EchoSchemaElReqDTO req, AuthoredUser user) {
        EchoSchemaElementLog echoSchemaElementLog = new EchoSchemaElementLog();
        BeanUtils.copyProperties((Object)req, (Object)echoSchemaElementLog);
        echoSchemaElementLog.setCreateTime(new Date());
        AbsEchoService.TranslationService translationService = new AbsEchoService.TranslationService();
        ArrayList<String> translates = new ArrayList<String>();
        translates.add(echoSchemaElementLog.getTarget());
        translates.add(echoSchemaElementLog.getPoint());
        translates.add(echoSchemaElementLog.getSchemaGroup());
        translates.add(echoSchemaElementLog.getSchemaCondition());
        translates.add(echoSchemaElementLog.getSchemaSort());
        List<CompletableFuture> translationFutures = translates.stream().map(arg_0 -> ((AbsEchoService.TranslationService)translationService).translate(arg_0)).collect(Collectors.toList());
        CompletableFuture<Void> allTranslations = CompletableFuture.allOf(translationFutures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)allTranslations.thenRun(() -> {
            echoSchemaElementLog.setComplexTarget((String)((CompletableFuture)translationFutures.get(0)).join());
            echoSchemaElementLog.setComplexPoint((String)((CompletableFuture)translationFutures.get(1)).join());
            echoSchemaElementLog.setComplexSchemaGroup((String)((CompletableFuture)translationFutures.get(2)).join());
            echoSchemaElementLog.setComplexSchemaCondition((String)((CompletableFuture)translationFutures.get(3)).join());
            echoSchemaElementLog.setComplexSchemaSort((String)((CompletableFuture)translationFutures.get(4)).join());
            this.echoSchemaElLogMapper.insert((Object)echoSchemaElementLog);
        })).join();
    }

    public List<EchoSchemaEIResDTO> getSchemaElInfoByMessageId(String messageId, AuthoredUser user) {
        ArrayList<EchoSchemaEIResDTO> results = new ArrayList<EchoSchemaEIResDTO>();
        List echoSchemaElementLogs = this.echoSchemaElLogMapper.getSchemaElInfoByMessageId(messageId);
        if (CollectionUtils.isEmpty((Collection)echoSchemaElementLogs)) {
            return new ArrayList<EchoSchemaEIResDTO>();
        }
        String userLangName = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        for (EchoSchemaElementLog res : echoSchemaElementLogs) {
            EchoSchemaEIResDTO echoSchemaElementLog = new EchoSchemaEIResDTO();
            if ("zh_TW".equals(userLangName)) {
                BeanUtils.copyProperties((Object)res, (Object)echoSchemaElementLog);
                echoSchemaElementLog.setTarget(res.getComplexTarget());
                echoSchemaElementLog.setPoint(res.getComplexPoint());
                echoSchemaElementLog.setSchemaGroup(res.getComplexSchemaGroup());
                echoSchemaElementLog.setSchemaCondition(res.getComplexSchemaCondition());
                echoSchemaElementLog.setSchemaSort(res.getComplexSchemaSort());
                results.add(echoSchemaElementLog);
                continue;
            }
            BeanUtils.copyProperties((Object)res, (Object)echoSchemaElementLog);
            results.add(echoSchemaElementLog);
        }
        return results;
    }

    public LinkedHashMap<String, Object> getInfoAndSchema(String messageId, AuthoredUser user) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        List tileList = CommonConstants.ECHO_SIMPLE_TITLE;
        List echoList = CommonConstants.ECHO_INFO_SIMPLE_LIST;
        List schemaList = CommonConstants.SCHEMA_SIMPLE_LIST;
        String userLangName = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        if ("zh_TW".equals(userLangName)) {
            tileList = CommonConstants.ECHO_COMPLEX_TITLE;
            echoList = CommonConstants.ECHO_INFO_COMPLEX_LIST;
            schemaList = CommonConstants.SCHEMA_COMPLEX_LIST;
        }
        List echoInfos = this.echoInformationService.getExceptionInfoByMessageId(messageId, user);
        List echoSchemaElementLogs = this.getSchemaElInfoByMessageId(messageId, user);
        try {
            res.put((String)tileList.get(0), EchoSchemaElServiceImpl.convertEchoInfoObject((List)echoInfos, (List)echoList));
            res.put((String)tileList.get(1), EchoSchemaElServiceImpl.convertEchoSchemaObject((List)echoSchemaElementLogs, (List)schemaList));
        }
        catch (Exception e) {
            log.info("getInfoAndSchema convertObject is error");
        }
        return res;
    }

    public static List<Map<String, Object>> convertEchoInfoObject(List<EchoInformationResDTO> list, List<String> enums) {
        Field[] fields;
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<Map<String, Object>>();
        }
        EchoInformationResDTO echoInformation = list.get(0);
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        for (Field field : fields = echoInformation.getClass().getDeclaredFields()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            switch (field.getName()) {
                case "appName": {
                    map.put(enums.get(0), StringUtils.isEmpty((String)echoInformation.getAppName()) ? "" : echoInformation.getAppName());
                    break;
                }
                case "description": {
                    map.put(enums.get(1), StringUtils.isEmpty((String)echoInformation.getDescription()) ? "" : echoInformation.getDescription());
                    break;
                }
                case "createTime": {
                    map.put(enums.get(2), Objects.isNull(echoInformation.getCreateTime()) ? "" : echoInformation.getCreateTime());
                    break;
                }
                case "content": {
                    map.put(enums.get(3), StringUtils.isEmpty((String)echoInformation.getContent()) ? "" : echoInformation.getContent());
                    break;
                }
                case "extend": {
                    map.put(enums.get(4), StringUtils.isEmpty((String)echoInformation.getExtend()) ? "" : echoInformation.getExtend());
                }
            }
            if (map.isEmpty()) continue;
            res.add(map);
        }
        return res;
    }

    public static List<Map<String, Object>> convertEchoSchemaObject(List<EchoSchemaEIResDTO> list, List<String> enums) {
        Field[] fields;
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<Map<String, Object>>();
        }
        EchoSchemaEIResDTO echoSchemaElementLog = list.get(0);
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        for (Field field : fields = echoSchemaElementLog.getClass().getDeclaredFields()) {
            HashMap<String, String> map = new HashMap<String, String>();
            switch (field.getName()) {
                case "target": {
                    map.put(enums.get(0), StringUtils.isEmpty((String)echoSchemaElementLog.getTarget()) ? "" : echoSchemaElementLog.getTarget());
                    break;
                }
                case "point": {
                    map.put(enums.get(1), StringUtils.isEmpty((String)echoSchemaElementLog.getPoint()) ? "" : echoSchemaElementLog.getPoint());
                    break;
                }
                case "schemaGroup": {
                    map.put(enums.get(2), StringUtils.isEmpty((String)echoSchemaElementLog.getSchemaGroup()) ? "" : echoSchemaElementLog.getSchemaGroup());
                    break;
                }
                case "schemaTime": {
                    map.put(enums.get(3), StringUtils.isEmpty((String)echoSchemaElementLog.getSchemaTime()) ? "" : echoSchemaElementLog.getSchemaTime());
                    break;
                }
                case "schemaCondition": {
                    map.put(enums.get(4), StringUtils.isEmpty((String)echoSchemaElementLog.getSchemaCondition()) ? "" : echoSchemaElementLog.getSchemaCondition());
                    break;
                }
                case "schemaRestrict": {
                    map.put(enums.get(5), StringUtils.isEmpty((String)echoSchemaElementLog.getSchemaRestrict()) ? "" : echoSchemaElementLog.getSchemaRestrict());
                    break;
                }
                case "schemaSort": {
                    map.put(enums.get(6), StringUtils.isEmpty((String)echoSchemaElementLog.getSchemaSort()) ? "" : echoSchemaElementLog.getSchemaSort());
                }
            }
            if (map.isEmpty()) continue;
            res.add(map);
        }
        return res;
    }
}

