/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.agiledataecho.service.MoreActionUserSelectService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class MoreActionUserSelectServiceImpl
implements MoreActionUserSelectService {
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_user_define";

    public List<Object> queryMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("sceneCode").is((Object)selectInfo.getSceneCode()).and("actionId").is((Object)selectInfo.getActionId()).and("type").is((Object)selectInfo.getType()));
        AgileDataUserDefine userDefine = (AgileDataUserDefine)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if (userDefine != null) {
            return userDefine.getUserSelectInfo();
        }
        return null;
    }

    public boolean submitMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        if (selectInfo == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("sceneCode").is((Object)selectInfo.getSceneCode()).and("actionId").is((Object)selectInfo.getActionId()).and("type").is((Object)selectInfo.getType()));
        AgileDataUserDefine agileDataUserDefine = (AgileDataUserDefine)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        if (agileDataUserDefine == null) {
            AgileDataUserDefine userDefine = new AgileDataUserDefine();
            userDefine.setUserId(user.getUserId());
            userDefine.setTenantId(user.getTenantId());
            userDefine.setSceneCode(selectInfo.getSceneCode());
            userDefine.setActionId(selectInfo.getActionId());
            userDefine.setType(selectInfo.getType());
            userDefine.setUserSelectInfo(selectInfo.getSelectInfo());
            this.mongoAgileDataPageViewTemplate.insert((Object)userDefine, MONGODB_COLLECTION_NAME);
        } else {
            Update update = new Update();
            update.set("userSelectInfo", (Object)selectInfo.getSelectInfo());
            this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataUserDefine.class, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public boolean deleteMoreActionUserSelectInfo(SceneSelectInfo selectInfo, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("sceneCode").is((Object)selectInfo.getSceneCode()).and("type").is((Object)selectInfo.getType()));
        this.mongoAgileDataPageViewTemplate.remove(query, MONGODB_COLLECTION_NAME);
        return true;
    }
}

