/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.util;

import com.digiwin.athena.agiledataecho.util.BatchConsumer;
import java.util.List;
import java.util.Objects;
import org.apache.http.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDataOperation<T extends List<?>> {
    private static final Logger log = LoggerFactory.getLogger(BatchDataOperation.class);
    private T dataList;

    public BatchDataOperation(T dataList) {
        this.dataList = dataList;
    }

    public void batchOperate(BatchConsumer<T> action, int maxDataSizePerBatch) {
        Asserts.check((maxDataSizePerBatch > 0 ? 1 : 0) != 0, (String)"maxDataSizePerBatch value must > 0.");
        Objects.requireNonNull(action);
        int length = this.dataList.size();
        for (int i = 0; i < length; i += maxDataSizePerBatch) {
            int toIndex = i + maxDataSizePerBatch;
            if (toIndex > length) {
                toIndex = length;
            }
            log.info("batch consume fromIndex:{} -- toIndex: {} ", (Object)i, (Object)toIndex);
            action.accept(this.dataList.subList(i, toIndex));
        }
    }
}

