/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.analyzer;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileReportPageDefineAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(AgileReportPageDefineAnalyzer.class);
    @Autowired
    protected MessageUtils messageUtils;
    @Autowired
    private List<AgileDataPageDefineService> pageDefines;

    private AgileDataPageDefineService getPageDefine(SnapDataDTO snapDataDTO) {
        AgileDataPageDefineService agileDataPageDefineService = null;
        for (AgileDataPageDefineService pageDefine : this.pageDefines) {
            String supportKey = "AGILEDATA_DEFINE_" + snapDataDTO.getSnapData().getQueryType();
            if (!StringUtils.equals((String)pageDefine.supportKey(), (String)supportKey)) continue;
            agileDataPageDefineService = pageDefine;
            break;
        }
        return agileDataPageDefineService;
    }

    public AgileReport analysis(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReport agileReport;
        try {
            AgileDataPageDefineService agileDataPageDefineService = this.getPageDefine(snapDataDTO);
            agileReport = Objects.requireNonNull(agileDataPageDefineService).analysis(executeContext, snapDataDTO);
        }
        catch (BusinessException e) {
            log.error("\u5feb\u7167ID:{},\u89e3\u6790\u654f\u6377\u6570\u636e\u5448\u73b0\u5f02\u5e38\uff1a{},{}", new Object[]{snapDataDTO.getSnapData().getSnapshotId(), e.getMessage(), e.toString()});
            throw e;
        }
        catch (Exception e) {
            log.error("\u5feb\u7167ID:{},\u89e3\u6790\u654f\u6377\u6570\u636e\u5448\u73b0\u5f02\u5e38\uff1a{},{}", new Object[]{snapDataDTO.getSnapData().getSnapshotId(), e.getMessage(), e.toString()});
            throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("P.AGILEDATAECHO.800.0004"));
        }
        if (agileReport == null || CollectionUtils.isEmpty((Collection)agileReport.getReport())) {
            throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        return agileReport;
    }
}

