/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.component.index;

import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

@Service(value="statistic")
public class AgileDataIndexComponentImpl
extends AbstractComponentService {
    private static final String COMPONENT_TYPE = "STATISTIC";

    public AgileDataIndexComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        AgileDataIndexComponent indexComponent = new AgileDataIndexComponent();
        ThemeMapReport themeMapReport = buildContext.getThemeMapReport();
        Map data = Maps.newHashMap();
        List pageData = themeMapReport.getPageData();
        if (CollectionUtils.isNotEmpty((Collection)pageData)) {
            data = (Map)pageData.get(0);
        }
        indexComponent.setType(COMPONENT_TYPE);
        indexComponent.setId(themeMapReport.getActionId());
        indexComponent.setTitle(themeMapReport.getTitle());
        ArrayList indexList = Lists.newArrayList();
        Map filedMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getActionId(), (ApiMetadata)themeMapReport.getApiMetadata());
        if (MapUtils.isNotEmpty((Map)filedMap)) {
            Map finalData = data;
            filedMap.forEach((metadataFieldName, field) -> {
                AgileDataIndexComponent.AgileDataIndex index = new AgileDataIndexComponent.AgileDataIndex();
                index.setName(field.getDescription());
                index.setValue(finalData.get(field.getName()));
                index.setTip(field.getExplanation());
                ComponentFormat componentFormat = new ComponentFormat();
                componentFormat.setDecimal(field.getDecimal());
                componentFormat.setPercent(field.getPercent());
                componentFormat.setBusinessType(field.getBusinessType());
                componentFormat.setDecimalRule(ConvertAgileDataUtils.getDecimalRule((String)field.getDecimalRule()));
                componentFormat.setUnit(ConvertAgileDataUtils.getUnitRule((String)field.getUnit()));
                index.setFormat(componentFormat);
                indexList.add(index);
            });
        }
        indexComponent.setGroup((List)indexList);
        return indexComponent;
    }
}

