/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.controller;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/agile/"})
public class AgileReportController {
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AdtService adtService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    CacheManager cacheManager;

    @GetMapping(value={"report/show/{reportId}"})
    public ResponseEntity<?> createAgileReportPageTemplate(@PathVariable(value="reportId") String snapshotId, @RequestParam(value="entry", required=false) String entry, @RequestParam(value="module", required=false) Integer module) {
        SnapDataDTO agileReportDTO;
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        if (StringUtils.isEmpty((String)entry)) {
            entry = "0";
        }
        if (AgileDataCheck.sceneBasicCheck((SnapDataDTO)(agileReportDTO = this.adtService.getAdtReportBySnapshotId(snapshotId, executeContext.getLocale()))).booleanValue()) {
            throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        executeContext.appendAgileDataPageInfo("agiledata-page", agileReportDTO, agileReportDTO.getSnapData().getReportCode(), entry);
        return ResponseEntityWrapper.wrapperOk((Object)this.agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO));
    }

    @PostMapping(value={"transPresent"})
    public ResponseEntity<?> transAgileData(@RequestBody Map<String, Object> transParams) {
        String snapshotId = transParams.get("snapshotId").toString();
        String transId = transParams.get("transId").toString();
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        executeContext.setTransId(transId);
        SnapDataDTO agileReportDTO = this.adtService.transAgileData(transId, snapshotId, executeContext.getLocale());
        if (AgileDataCheck.sceneBasicCheck((SnapDataDTO)agileReportDTO).booleanValue()) {
            throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_EMPTY_DATA.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.empty.data"));
        }
        executeContext.appendAgileDataPageInfo("agiledata-page", agileReportDTO, null, "0");
        DynamicAgileData dynamicForm = this.agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO);
        HashMap result = Maps.newHashMap();
        result.put("dsl", dynamicForm);
        result.put("dataTipMessage", agileReportDTO.getSnapData().getTransTips());
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"clean/agileData/rest"})
    public ResponseEntity<?> cleanAgileDataRest(@RequestParam(value="redisKey", required=false) String redisKey) {
        this.cacheManager.delete("adt:cache:", (Object)redisKey);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }
}

