/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AgileDataGridsterArea {
    private int x;
    private int y;
    private int cols;
    private int rows;
    private int componentWidth;
    private int componentHeight;
    private AbstractComponent component;
    private Set<Integer> nextLevel;
    private String relationType;

    public AgileDataGridsterArea(AbstractComponent abstractComponent, String relationType) {
        this.component = abstractComponent;
        this.relationType = relationType;
    }

    public void setSize() {
        String type = this.relationType;
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = this.component.getType();
        }
        switch (type) {
            case "LABEL": {
                this.cols = 4;
                this.rows = 1;
                break;
            }
            case "STATISTIC": {
                if (this.component instanceof AgileDataIndexComponent) {
                    AgileDataIndexComponent indexComponent = (AgileDataIndexComponent)this.component;
                    int colSize = indexComponent.getGroup().size() > 6 ? 6 : indexComponent.getGroup().size();
                    this.cols = colSize * 2;
                    this.rows = indexComponent.getGroup().size() > 6 ? 3 : 2;
                    break;
                }
                this.cols = 2;
                this.rows = 2;
                break;
            }
            case "ECHARTS": {
                this.cols = 6;
                this.rows = 5;
                break;
            }
            default: {
                this.cols = 12;
                this.rows = 6;
            }
        }
    }

    public void setSize(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    public void reSize(int arrangeSize, int prevGroupSize) {
        if (this.component instanceof AgileDataIndexComponent) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.nextLevel)) {
            this.cols = arrangeSize - prevGroupSize;
        }
    }

    public void reSizeProportion(int arrangeSize, int maxWidthSize) {
        double proportion;
        if (!StringUtils.equals((CharSequence)"STATISTIC", (CharSequence)this.component.getType()) && (proportion = (double)this.cols / (double)arrangeSize) > 0.0) {
            this.cols = (int)((double)maxWidthSize * proportion);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public int getComponentWidth() {
        return this.componentWidth;
    }

    public int getComponentHeight() {
        return this.componentHeight;
    }

    public AbstractComponent getComponent() {
        return this.component;
    }

    public Set<Integer> getNextLevel() {
        return this.nextLevel;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setComponentWidth(int componentWidth) {
        this.componentWidth = componentWidth;
    }

    public void setComponentHeight(int componentHeight) {
        this.componentHeight = componentHeight;
    }

    public void setComponent(AbstractComponent component) {
        this.component = component;
    }

    public void setNextLevel(Set<Integer> nextLevel) {
        this.nextLevel = nextLevel;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataGridsterArea)) {
            return false;
        }
        AgileDataGridsterArea other = (AgileDataGridsterArea)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getCols() != other.getCols()) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getComponentWidth() != other.getComponentWidth()) {
            return false;
        }
        if (this.getComponentHeight() != other.getComponentHeight()) {
            return false;
        }
        AbstractComponent this$component = this.getComponent();
        AbstractComponent other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        Set this$nextLevel = this.getNextLevel();
        Set other$nextLevel = other.getNextLevel();
        if (this$nextLevel == null ? other$nextLevel != null : !((Object)this$nextLevel).equals(other$nextLevel)) {
            return false;
        }
        String this$relationType = this.getRelationType();
        String other$relationType = other.getRelationType();
        return !(this$relationType == null ? other$relationType != null : !this$relationType.equals(other$relationType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataGridsterArea;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getCols();
        result = result * 59 + this.getRows();
        result = result * 59 + this.getComponentWidth();
        result = result * 59 + this.getComponentHeight();
        AbstractComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        Set $nextLevel = this.getNextLevel();
        result = result * 59 + ($nextLevel == null ? 43 : ((Object)$nextLevel).hashCode());
        String $relationType = this.getRelationType();
        result = result * 59 + ($relationType == null ? 43 : $relationType.hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataGridsterArea(x=" + this.getX() + ", y=" + this.getY() + ", cols=" + this.getCols() + ", rows=" + this.getRows() + ", componentWidth=" + this.getComponentWidth() + ", componentHeight=" + this.getComponentHeight() + ", component=" + this.getComponent() + ", nextLevel=" + this.getNextLevel() + ", relationType=" + this.getRelationType() + ")";
    }
}

