/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterGroup;
import com.google.common.collect.Lists;
import java.util.List;

public class AgileDataGridsterArrange {
    private int width;
    private int height;
    private List<AgileDataGridsterGroup> groups = Lists.newArrayList();

    public void setSize() {
        this.width = 0;
        this.height = 0;
        this.groups.stream().forEach(group -> {
            this.width += group.getWidth();
            this.height = group.getHeight();
        });
    }

    public void reSize(int maxWidth) {
        this.groups.stream().forEach(group -> group.reSize(this.width, maxWidth));
        this.setSize();
    }

    public void completionSize() {
        int prevWidth = 0;
        int size = 0;
        for (AgileDataGridsterGroup group : this.groups) {
            group.completionSize(this.width, prevWidth, size == this.groups.size() - 1);
            prevWidth += group.getWidth();
        }
        this.setSize();
    }

    public void setCoordinate(int prevHeight) {
        int groupWidth = 0;
        for (AgileDataGridsterGroup group : this.groups) {
            group.calcCoordinate(groupWidth, prevHeight);
            groupWidth += group.getWidth();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<AgileDataGridsterGroup> getGroups() {
        return this.groups;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setGroups(List<AgileDataGridsterGroup> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataGridsterArrange)) {
            return false;
        }
        AgileDataGridsterArrange other = (AgileDataGridsterArrange)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        List this$groups = this.getGroups();
        List other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataGridsterArrange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        List $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataGridsterArrange(width=" + this.getWidth() + ", height=" + this.getHeight() + ", groups=" + this.getGroups() + ")";
    }
}

