/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.ComponentDecimalRule;
import com.digiwin.athena.show.component.ComponentUnit;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class ConvertAgileDataUtils {
    private static JSONObject buildSetting(ThemeMapReport themeMapReport) {
        HashMap titleMap = Maps.newHashMap();
        titleMap.put("tableTitle", themeMapReport.getTitle());
        HashMap map = Maps.newHashMap();
        map.put(themeMapReport.getDataSourceName(), titleMap);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll((Map)map);
        return jsonObject;
    }

    public static Map<String, Object> getDataTag(SnapDataDTO snapDataDTO, String actionId) {
        Map<Object, Object> businessMap = Maps.newHashMap();
        if (snapDataDTO != null && MapUtils.isNotEmpty((Map)snapDataDTO.getPageData())) {
            Map dataTag;
            Map dataMap;
            Optional<Map> dataTagOptional;
            List dataList = (List)snapDataDTO.getPageData().get(actionId);
            List fields = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)dataList) && (dataTagOptional = dataList.stream().filter(data -> data.containsKey("dataTag")).findFirst()).isPresent() && MapUtils.isNotEmpty((Map)(dataMap = dataTagOptional.get())) && dataMap.containsKey("dataTag") && (dataTag = (Map)dataMap.get("dataTag")).containsKey("fields")) {
                fields = (List)dataTag.get("fields");
            }
            if (!CollectionUtils.isEmpty((Collection)fields)) {
                businessMap = fields.stream().collect(Collectors.toMap(map -> map.containsKey("field") ? map.get("field").toString() : "", map -> map.containsKey("businessType") ? map.get("businessType").toString() : "", (existingValue, newValue) -> existingValue));
            }
        }
        return businessMap;
    }

    public static ComponentDecimalRule getDecimalRule(String rule) {
        ComponentDecimalRule decimalRule = new ComponentDecimalRule();
        if (StringUtils.isNotEmpty((String)rule)) {
            Integer roundValue = null;
            Boolean transABS = null;
            String roundMode = "";
            switch (rule) {
                case "up": {
                    roundMode = "up";
                    transABS = false;
                    break;
                }
                case "down": {
                    roundMode = "down";
                    transABS = false;
                    break;
                }
                case "round": {
                    roundMode = "round";
                    roundValue = 5;
                    transABS = false;
                    break;
                }
                case "absUp": {
                    roundMode = "up";
                    transABS = true;
                    break;
                }
                case "absDown": {
                    roundMode = "down";
                    transABS = true;
                    break;
                }
            }
            if (StringUtils.isNotEmpty((String)roundMode)) {
                decimalRule.setRoundValue(roundValue);
                decimalRule.setTransABS(transABS);
                decimalRule.setRoundMode(roundMode);
            }
        }
        return decimalRule;
    }

    public static String getDecimalJS(String rule) {
        StringBuilder jsString = new StringBuilder();
        if (StringUtils.isNotEmpty((String)rule)) {
            Integer roundValue = null;
            Boolean transABS = null;
            String roundMode = "";
            switch (rule) {
                case "up": {
                    roundMode = "up";
                    transABS = false;
                    break;
                }
                case "down": {
                    roundMode = "down";
                    transABS = false;
                    break;
                }
                case "round": {
                    roundMode = "round";
                    roundValue = 5;
                    transABS = false;
                    break;
                }
                case "absUp": {
                    roundMode = "up";
                    transABS = true;
                    break;
                }
                case "absDown": {
                    roundMode = "down";
                    transABS = true;
                    break;
                }
            }
            if (StringUtils.isNotEmpty((String)roundMode)) {
                jsString.append("const decimalRule = { ");
                jsString.append(" roundMode: ");
                jsString.append("'");
                jsString.append(roundMode);
                jsString.append("'");
                jsString.append(",");
                if (transABS != null) {
                    jsString.append(" transABS: ");
                    jsString.append(transABS);
                    jsString.append(",");
                }
                if (roundValue != null) {
                    jsString.append(" roundValue: ");
                    jsString.append(roundValue);
                    jsString.append(",");
                }
                jsString.deleteCharAt(jsString.lastIndexOf(","));
                jsString.append(" }; ");
            }
        }
        return jsString.toString();
    }

    public static ComponentUnit getUnitRule(String rule) {
        ComponentUnit componentUnit = new ComponentUnit();
        if (StringUtils.isNotEmpty((String)rule)) {
            componentUnit.setType("metering");
            componentUnit.setValue(rule);
        }
        return componentUnit;
    }

    public static String getUnitJS(String rule) {
        StringBuilder jsString = new StringBuilder();
        if (StringUtils.isNotEmpty((String)rule)) {
            jsString.append("const unit = { ");
            jsString.append(" type: ");
            jsString.append("'metering'");
            jsString.append(",");
            jsString.append(" value: '");
            jsString.append(rule);
            jsString.append("'");
            jsString.append(" }; ");
        }
        return jsString.toString();
    }

    public static Boolean isNeedDefaultModel(ExecuteContext executeContext) {
        Map agileData = executeContext.getAgileData();
        if (MapUtils.isEmpty((Map)agileData)) {
            return false;
        }
        if (!agileData.containsKey("screenModel")) {
            return false;
        }
        return true;
    }
}

