/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataFilter;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataTag;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportCard;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportChartTypeEnum;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportECharts;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportIndex;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.domain.showDefine.DataSourceBase;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileReportEChartBuildService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class AgileDataPageDefineService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataPageDefineService.class);
    @Autowired
    private AgileReportEChartBuildService agileReportEChartBuildService;
    @Autowired
    private ThemeAgileDataService themeAgileDataService;
    private static final List<String> AGILE_RULES = Lists.newArrayList((Object[])new String[]{"alertShow", "growthRate"});

    public abstract String supportKey();

    public AgileReport analysis(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData = this.getAgileReportDefine(executeContext, snapDataDTO);
        return this.transKMDefine(agileReportKMData, snapDataDTO, executeContext);
    }

    private AgileReport transKMDefine(AgileReportKMData agileReportKMData, SnapDataDTO snapDataDTO, ExecuteContext executeContext) {
        AgileReport agileReport = new AgileReport();
        if (agileReportKMData == null) {
            return agileReport;
        }
        agileReport.setDimensionInterval(snapDataDTO.getSnapData().getDimensionInterval());
        agileReport.setAliasGrain(snapDataDTO.getSnapData().getAliasGrain());
        this.buildScreenModel(agileReportKMData, executeContext);
        this.buildAgileReport(agileReport, agileReportKMData);
        this.buildThemeMapReport(agileReport, agileReportKMData, snapDataDTO, executeContext);
        return agileReport;
    }

    protected abstract void buildScreenModel(AgileReportKMData var1, ExecuteContext var2);

    private void buildThemeMapReport(AgileReport agileReport, AgileReportKMData agileReportKMData, SnapDataDTO snapDataDTO, ExecuteContext executeContext) {
        String[] actionIdList;
        for (String actionId : actionIdList = agileReportKMData.getActionId().split(",")) {
            List agileDataListList;
            log.info("\u5206\u6790\u5448\u73b0\u5b9a\u4e49\uff1a{}", (Object)actionId);
            ApiMetadata apiMetadata = this.getApiMetadata(snapDataDTO, executeContext, actionId);
            if (this.judgeDefine("metadata", executeContext, apiMetadata, null, null, null).booleanValue() || this.judgeDefine("agileData", executeContext, null, agileDataListList = (List)snapDataDTO.getPageData().get(actionId), null, null).booleanValue()) continue;
            String sourceNamePrefix = actionId;
            TargetDTO targetDTO = this.getTargetDTO(agileReportKMData, actionId);
            if (this.judgeDefine("target", executeContext, null, null, targetDTO, null).booleanValue()) continue;
            this.changeApiData(apiMetadata, sourceNamePrefix);
            this.changeData(agileDataListList, sourceNamePrefix, targetDTO);
            String OriginalSourceName = "";
            Optional<AgileReportShow> agileReportShowOptional = agileReportKMData.getShow().stream().filter(agileShow -> Objects.equals(agileShow.getActionId(), actionId)).findFirst();
            if (agileReportShowOptional.isPresent()) {
                AgileReportShow agileReportShow = agileReportShowOptional.get();
                OriginalSourceName = agileReportShow.getTargetSource();
            }
            this.changeKMDefine(agileReportKMData, actionId, OriginalSourceName, apiMetadata, targetDTO);
            String sourceName = this.getSourceName(apiMetadata.getResponseFields(), "", targetDTO);
            agileReport.setDataSourceBase(this.buildDataSource(actionId, sourceName));
            AgileReportShowTypeDTO agileReportShowTypeDTO = this.bindShowType(actionId, agileReportKMData);
            if (agileReportShowTypeDTO == null) continue;
            agileReportShowTypeDTO.getType().stream().forEach(agileShowType -> {
                log.info("\u7ed1\u5b9a\u5448\u73b0\u4fe1\u606f\uff1a{}", agileShowType);
                ThemeMapReport themeMapReport = new ThemeMapReport();
                themeMapReport.setActionId(actionId);
                this.buildReportData(agileDataListList, themeMapReport, apiMetadata, targetDTO);
                if (this.judgeDefine("pageData", executeContext, null, null, null, themeMapReport.getPageData()).booleanValue()) {
                    return;
                }
                agileReport.getReport().add(themeMapReport);
                themeMapReport.setAppCode(agileReportKMData.getAppCode());
                themeMapReport.setPageTurningFrequency(agileReportKMData.getPageTurningFrequency());
                themeMapReport.setReportShow(agileShowType.getValue());
                themeMapReport.setAgileDataRelation(agileReportKMData.getActionRelation());
                agileShowType.setBiValue(this.getBiValue(agileShowType));
                themeMapReport.setApiMetadata(apiMetadata);
                themeMapReport.setPageData(themeMapReport.getPageData());
                themeMapReport.setTitle(this.getTitle(agileShowType, snapDataDTO, apiMetadata, themeMapReport, executeContext));
                themeMapReport.setDataSourceName(sourceName);
                themeMapReport.setCode(sourceName + "_" + themeMapReport.getReportShow());
                this.buildShow(agileReportKMData, agileReportShowTypeDTO, actionId, themeMapReport, agileShowType, snapDataDTO, executeContext);
            });
        }
    }

    protected abstract Boolean judgeDefine(String var1, ExecuteContext var2, ApiMetadata var3, List<Map<String, Object>> var4, TargetDTO var5, List<Map<String, Object>> var6);

    private String getBiValue(AgileReportShowTypeInfoDTO showType) {
        String biValue = "";
        if (showType.getValue() != null && showType.getValue() > 2) {
            switch (showType.getValue()) {
                case 4: {
                    biValue = "\u6df7\u5408\u56fe";
                    break;
                }
                case 5: {
                    biValue = "\u66f2\u7ebf\u56fe";
                    break;
                }
                case 6: {
                    biValue = "\u997c\u56fe";
                    break;
                }
                default: {
                    biValue = "\u67f1\u5f62\u56fe";
                }
            }
        }
        return biValue;
    }

    private void buildShow(AgileReportKMData agileReportKMData, AgileReportShowTypeDTO agileReportShowTypeDTO, String actionId, ThemeMapReport themeMapReport, AgileReportShowTypeInfoDTO showType, SnapDataDTO snapDataDTO, ExecuteContext executeContext) {
        Optional<AgileReportShow> agileReportShowOptional = agileReportKMData.getShow().stream().filter(agileShow -> Objects.equals(agileShow.getActionId(), actionId)).findFirst();
        AgileReportShow agileReportShow = new AgileReportShow();
        if (agileReportShowOptional.isPresent()) {
            agileReportShow = agileReportShowOptional.get();
            themeMapReport.setAgileRule(agileReportShow.getAgileRule());
        } else {
            themeMapReport.setReportShow(Integer.valueOf(0));
        }
        themeMapReport.setDataSource(agileReportShow.getTargetSource());
        log.info("\u7ed1\u5b9a\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JsonUtils.objectToString((Object)themeMapReport.getReportShow()));
        switch (themeMapReport.getReportShow()) {
            case 0: {
                this.bindTable(themeMapReport, agileReportShow);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.bindEChart(agileReportShow, agileReportShowTypeDTO, themeMapReport.getApiMetadata(), themeMapReport, themeMapReport.getPageData(), showType);
                break;
            }
            case 7: {
                this.bindCard(agileReportKMData, agileReportShow, themeMapReport, showType, executeContext, snapDataDTO);
                break;
            }
            case 2: {
                this.bindIndex(agileReportShow, themeMapReport);
                break;
            }
            default: {
                this.bindTable(themeMapReport, agileReportShow);
            }
        }
    }

    private void bindEChart(AgileReportShow agileReportShow, AgileReportShowTypeDTO agileReportShowTypeDTO, ApiMetadata apiMetadata, ThemeMapReport themeMapReport, List<Map<String, Object>> pageList, AgileReportShowTypeInfoDTO showType) {
        AgileReportECharts agileReportECharts = new AgileReportECharts();
        ArrayList eChartsDataList = Lists.newArrayList();
        for (AgileReportEChartDefineDTO eChartsDefine : agileReportShow.getEChart()) {
            List rules;
            AgileReportECharts.EChartsData eChartsData = new AgileReportECharts.EChartsData();
            AgileReportECharts.EChartsDataDefine point = new AgileReportECharts.EChartsDataDefine();
            ArrayList values = Lists.newArrayList();
            point.setApplyToField(eChartsDefine.getXAxis().getApplyToField());
            ArrayList ruleFields = Lists.newArrayList();
            if (agileReportShow.getAgileRule() != null && !CollectionUtils.isEmpty(rules = agileReportShow.getAgileRule().stream().filter(x -> AGILE_RULES.contains(x.getType())).collect(Collectors.toList()))) {
                rules.stream().forEach(rule -> {
                    switch (rule.getType()) {
                        case "growthRate": {
                            rule.getRules().stream().forEach(ruleField -> ruleFields.add(ruleField.getApplyToField()));
                            break;
                        }
                    }
                });
            }
            eChartsDefine.getSeries().stream().forEach(eChartSeries -> {
                if (!ruleFields.contains(eChartSeries.getApplyToField())) {
                    AgileReportECharts.EChartsDataDefine eChartsDataDefine = new AgileReportECharts.EChartsDataDefine();
                    eChartsDataDefine.setApplyToField(eChartSeries.getApplyToField());
                    eChartsDataDefine.setChart(eChartSeries.getChart());
                    values.add(eChartsDataDefine);
                }
            });
            eChartsData.setPoints((List)Lists.newArrayList((Object[])new AgileReportECharts.EChartsDataDefine[]{point}));
            eChartsData.setValues((List)values);
            eChartsDataList.add(eChartsData);
        }
        agileReportECharts.setData((List)eChartsDataList);
        agileReportECharts.setTitle(themeMapReport.getTitle());
        String chartType = "";
        if (StringUtils.isEmpty((String)showType.getBiValue())) {
            Map eChartParams = this.agileReportEChartBuildService.getChartParams(agileReportShow, agileReportShowTypeDTO, apiMetadata, pageList);
            chartType = this.themeAgileDataService.findLastNodeShapeType(eChartParams);
            if (StringUtils.isEmpty((String)chartType)) {
                chartType = "\u67f1\u5f62\u56fe";
            }
        } else {
            chartType = showType.getBiValue();
        }
        if (!CollectionUtils.isEmpty((Collection)agileReportShow.getEChart()) && agileReportShow.getEChart().size() > 1) {
            chartType = "\u6df7\u5408\u56fe";
        }
        agileReportECharts.setChartType(AgileReportChartTypeEnum.getType((String)chartType));
        themeMapReport.setECharts(agileReportECharts);
    }

    private void bindCard(AgileReportKMData agileReportKMData, AgileReportShow agileReportShow, ThemeMapReport themeMapReport, AgileReportShowTypeInfoDTO showType, ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileDataFilter agileDataFilter;
        Optional agileDataFilterOptional;
        AgileReportCard agileReportCard = new AgileReportCard();
        agileReportCard.setCardDefine(agileReportShow.getCard());
        if (!CollectionUtils.isEmpty((Collection)showType.getFilter()) && (agileDataFilterOptional = showType.getFilter().stream().findFirst()).isPresent() && StringUtils.isNotEmpty((String)(agileDataFilter = (AgileDataFilter)agileDataFilterOptional.get()).getActionId())) {
            Optional filterOptional = agileReportKMData.getShow().stream().filter(show -> StringUtils.equals((String)agileDataFilter.getActionId(), (String)show.getActionId())).flatMap(show -> {
                if (show.getAgileRule() == null || show.getAgileRule().isEmpty()) {
                    return Stream.empty();
                }
                return show.getAgileRule().stream().filter(rule -> StringUtils.equals((String)"filter", (String)rule.getType()));
            }).findFirst();
            if (filterOptional.isPresent()) {
                agileDataFilter.setAgileReportRule((AgileReportRuleDTO)filterOptional.get());
            }
            agileDataFilter.setApiMetadata(this.getApiMetadata(snapDataDTO, executeContext, agileDataFilter.getActionId()));
            Object filterData = snapDataDTO.getPageData().get(agileDataFilter.getActionId());
            List pageDataList = Lists.newArrayList();
            if (filterData instanceof List) {
                pageDataList = (List)filterData;
            } else {
                pageDataList.add((Map)filterData);
            }
            ArrayList dataList = Lists.newArrayList();
            MetadataField metadataField = ConvertGetAgileData.getRootMetadataField((ApiMetadata)agileDataFilter.getApiMetadata());
            if (!CollectionUtils.isEmpty((Collection)pageDataList)) {
                pageDataList.stream().forEach(data -> {
                    Map dataMap;
                    Object value;
                    Object dataObj = data.get("data");
                    if (dataObj != null && dataObj instanceof Map && (value = (dataMap = (Map)dataObj).get(metadataField.getName())) != null) {
                        if (value instanceof List) {
                            dataList.addAll((List)value);
                        } else {
                            dataList.add((Map)value);
                        }
                    }
                });
                agileDataFilter.setPageData((List)dataList);
            }
            agileReportCard.setFilter(agileDataFilter);
        }
        themeMapReport.setCard(agileReportCard);
    }

    private void bindIndex(AgileReportShow agileReportShow, ThemeMapReport themeMapReport) {
        AgileReportIndex agileReportIndex = new AgileReportIndex();
        agileReportIndex.setIndexes(agileReportShow.getAgileReportIndex().getIndexes());
        themeMapReport.setAgileReportIndex(agileReportIndex);
    }

    private void bindTable(ThemeMapReport themeMapReport, AgileReportShow agileReportShow) {
        if (agileReportShow.getTable() == null) {
            themeMapReport.setEnablePaging(Boolean.valueOf(true));
        }
    }

    private void buildReportData(List<Map<String, Object>> agileDataListList, ThemeMapReport themeMapReport, ApiMetadata apiMetadata, TargetDTO targetDTO) {
        if (CollectionUtils.isEmpty(agileDataListList)) {
            return;
        }
        ArrayList pageList = Lists.newArrayList();
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        String name = this.getApiObjName(apiMetadata, targetDTO);
        ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata((String)name, (ApiMetadata)apiMetadata);
        Map apiMap = ConvertGetAgileData.getFiledMasterMap((String)name, (ApiMetadata)masterApi);
        for (Map<String, Object> agileData : agileDataListList) {
            ArrayList dataList = Lists.newArrayList();
            ArrayList tempList = Lists.newArrayList();
            Object dataObj = agileData.get("data");
            if (dataObj == null) continue;
            if (dataObj instanceof Collection) {
                tempList.addAll((Collection)dataObj);
            } else {
                tempList.add((Map)dataObj);
            }
            if (!CollectionUtils.isEmpty((Collection)tempList)) {
                tempList.stream().forEach(tempData -> {
                    Map finalTempData = tempData;
                    apiMap.forEach((x, y) -> {
                        if (finalTempData.containsKey(x)) {
                            Object obj = finalTempData.get(x);
                            if (obj instanceof Collection) {
                                dataList.addAll((Collection)obj);
                            } else {
                                dataList.add((Map)obj);
                            }
                        }
                    });
                });
            }
            pageList.addAll(dataList);
        }
        themeMapReport.setPageData((List)pageList);
    }

    private AgileReportShowTypeDTO bindShowType(String actionId, AgileReportKMData agileReportKMData) {
        Optional<AgileReportShowTypeDTO> showTypeDTOOptional = agileReportKMData.getShowType().stream().filter(action -> StringUtils.equals((String)actionId, (String)action.getActionId())).findFirst();
        AgileReportShowTypeDTO agileReportShowTypeDTO = null;
        if (showTypeDTOOptional.isPresent()) {
            agileReportShowTypeDTO = showTypeDTOOptional.get();
            agileReportShowTypeDTO.getType().stream().forEach(showType -> {
                if (showType.getValue() == null) {
                    showType.setValue(Integer.valueOf(0));
                }
            });
        }
        return agileReportShowTypeDTO;
    }

    private Integer getShowType(ApiMetadata apiMetadata) {
        Integer showType = 0;
        if (StringUtils.isNotEmpty((String)apiMetadata.getShowType())) {
            showType = Integer.valueOf(apiMetadata.getShowType());
        }
        return showType;
    }

    private DataSourceBase buildDataSource(String actionId, String sourceName) {
        DataSourceBase dataSourceBase = new DataSourceBase();
        dataSourceBase.setActionId(actionId);
        return dataSourceBase;
    }

    private String getSourceName(List<MetadataField> responseFields, String sourceName, TargetDTO targetDTO) {
        String name = sourceName;
        for (MetadataField metadataField : responseFields) {
            if (!metadataField.isObjectField() || targetDTO == null || !StringUtils.equals((String)targetDTO.getName(), (String)metadataField.getOriginalName())) continue;
            name = metadataField.getName();
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields())) continue;
            name = this.getSourceName(metadataField.getSubFields(), name, targetDTO.getSubTarget());
        }
        return name;
    }

    private void changeKMDefine(AgileReportKMData agileReportKMData, String actionId, String sourceName, ApiMetadata apiMetadata, TargetDTO targetDTO) {
        List agileReportShowList;
        if (targetDTO == null) {
            return;
        }
        String newSourceName = this.getApiObjName(apiMetadata, targetDTO);
        List agileReportShowTypeDTOS = agileReportKMData.getShowType().stream().filter(x -> StringUtils.equals((String)actionId, (String)x.getActionId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(agileReportShowTypeDTOS)) {
            agileReportShowTypeDTOS.stream().forEach(showType -> showType.getType().stream().forEach(type -> type.setTitleSeat(this.changeDefineValue(type.getTitleSeat(), sourceName, newSourceName))));
        }
        if (!CollectionUtils.isEmpty(agileReportShowList = agileReportKMData.getShow().stream().filter(x -> StringUtils.equals((String)actionId, (String)x.getActionId())).collect(Collectors.toList()))) {
            agileReportShowList.stream().forEach(agileReportShow -> agileReportShow.setTargetSource(this.changeDefineValue(agileReportShow.getTargetSource(), sourceName, newSourceName)));
        }
    }

    private String changeDefineValue(String define, String sourceName, String newSourceName) {
        if (StringUtils.isEmpty((String)define)) {
            return null;
        }
        return define.replaceFirst(sourceName, newSourceName);
    }

    private String getApiObjName(ApiMetadata apiMetadata, TargetDTO targetDTO) {
        String name = "";
        for (MetadataField metadataField : apiMetadata.getResponseFields()) {
            if (!metadataField.isObjectField() || !StringUtils.equals((String)targetDTO.getName(), (String)metadataField.getOriginalName())) continue;
            name = metadataField.getName();
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields())) continue;
            name = name + this.getSubApiName(metadataField.getSubFields(), targetDTO.getSubTarget());
        }
        return name;
    }

    private String getSubApiName(List<MetadataField> metadataFieldList, TargetDTO targetDTO) {
        String apiName = "";
        for (MetadataField metadataField : metadataFieldList) {
            if (!metadataField.isObjectField() || targetDTO == null || !StringUtils.equals((String)targetDTO.getName(), (String)metadataField.getOriginalName())) continue;
            apiName = "." + metadataField.getName();
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields())) continue;
            apiName = apiName + this.getSubApiName(metadataField.getSubFields(), targetDTO.getSubTarget());
        }
        return apiName;
    }

    private void changeData(List<Map<String, Object>> agileDataListList, String newSourceName, TargetDTO targetDTO) {
        ArrayList dataList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(agileDataListList)) {
            return;
        }
        for (Map<String, Object> agileMap : agileDataListList) {
            Object obj = MapUtils.getObject(agileMap, (Object)"data");
            if (obj == null) continue;
            ArrayList objList = Lists.newArrayList();
            if (obj instanceof Collection) {
                objList.addAll((Collection)obj);
            } else {
                objList.add((Map)obj);
            }
            dataList.addAll(objList);
        }
        if (targetDTO != null) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map flatMap = this.changeSubData((Map)dataList.get(i), newSourceName, 0, targetDTO);
                ((Map)dataList.get(i)).putAll(flatMap);
            }
        }
    }

    private Map<String, Object> changeSubData(Map<String, Object> data, String sourceName, int num, TargetDTO targetDTO) {
        HashMap flatMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getValue() instanceof Map && StringUtils.equals((String)entry.getKey(), (String)targetDTO.getName())) {
                Map tempMap = (Map)entry.getValue();
                if (targetDTO.getSubTarget() != null) {
                    flatMap.putAll(this.changeSubData(tempMap, sourceName, num, targetDTO.getSubTarget()));
                } else {
                    flatMap.put(sourceName, tempMap);
                }
                ++num;
            }
            if (!(entry.getValue() instanceof Collection) || !StringUtils.equals((String)entry.getKey(), (String)targetDTO.getName())) continue;
            flatMap.put(sourceName, entry.getValue());
            ++num;
        }
        return flatMap;
    }

    private void changeApiData(ApiMetadata apiMetadata, String newSourceName) {
        int i = 0;
        for (MetadataField metadataField : apiMetadata.getResponseFields()) {
            if (!"object".equals(metadataField.getDataType())) continue;
            metadataField.setOriginalName(metadataField.getName());
            metadataField.setName(newSourceName);
            ++i;
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields())) continue;
            this.changeSubApiData(metadataField.getSubFields(), newSourceName, i);
        }
    }

    private void changeSubApiData(List<MetadataField> metadataFieldList, String newSourceName, int num) {
        for (MetadataField metadataField : metadataFieldList) {
            if (!"object".equals(metadataField.getDataType())) continue;
            metadataField.setOriginalName(metadataField.getName());
            metadataField.setName(newSourceName);
            this.changeSubApiData(metadataField.getSubFields(), newSourceName, ++num);
        }
    }

    private TargetDTO getTargetDTO(AgileReportKMData agileReportKMData, String actionId) {
        Optional<AgileReportShow> agileReportShowOptional = agileReportKMData.getShow().stream().filter(agileShow -> Objects.equals(agileShow.getActionId(), actionId)).findFirst();
        if (agileReportShowOptional.isPresent()) {
            AgileReportShow agileReportShow = agileReportShowOptional.get();
            if (StringUtils.isEmpty((String)agileReportShow.getTargetSource())) {
                return null;
            }
            return this.getTargetDataSource(agileReportShow.getTargetSource());
        }
        return null;
    }

    private TargetDTO getTargetDataSource(String targetSource) {
        TargetDTO targetDTO = new TargetDTO();
        if (!targetSource.contains(".")) {
            targetDTO.setName(targetSource);
            return targetDTO;
        }
        String[] targetArray = targetSource.split("\\.");
        TargetDTO tempTarget = new TargetDTO();
        for (int i = 0; i < targetArray.length; ++i) {
            if (i != 0) {
                TargetDTO subTarget = new TargetDTO();
                subTarget.setName(targetArray[i]);
                tempTarget.setSubTarget(subTarget);
                tempTarget = subTarget;
                continue;
            }
            targetDTO.setName(targetArray[i]);
            tempTarget = targetDTO;
        }
        return targetDTO;
    }

    private void buildAgileReport(AgileReport agileReport, AgileReportKMData agileReportKMData) {
        ArrayList report = Lists.newArrayList();
        agileReport.setReport((List)report);
        agileReport.setTitle(agileReportKMData.getSceneTitle());
        agileReport.setReportCode(agileReportKMData.getCode());
    }

    protected String getTargetSource(ApiMetadata apiMetadata) {
        String targetSource = "";
        List metadataFields = apiMetadata.getResponseFields();
        for (MetadataField metadataField : metadataFields) {
            String subName;
            if (!metadataField.isObjectField()) continue;
            targetSource = metadataField.getName();
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields()) || StringUtils.isEmpty((String)(subName = this.targetName(metadataField.getSubFields())))) continue;
            targetSource = targetSource + "." + subName;
        }
        return targetSource;
    }

    protected String targetName(List<MetadataField> metadataFields) {
        String targetName = "";
        for (MetadataField metadataField : metadataFields) {
            String subName;
            if (!metadataField.isObjectField()) continue;
            targetName = metadataField.getName();
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields()) || StringUtils.isEmpty((String)(subName = this.targetName(metadataField.getSubFields())))) continue;
            targetName = targetName + "." + subName;
        }
        return targetName;
    }

    protected abstract AgileReportKMData getAgileReportDefine(ExecuteContext var1, SnapDataDTO var2);

    protected abstract ApiMetadata getApiMetadata(SnapDataDTO var1, ExecuteContext var2, String var3);

    protected abstract AgileDataTag getAgileDataTag(SnapDataDTO var1, ExecuteContext var2, String var3);

    protected abstract String getTitle(AgileReportShowTypeInfoDTO var1, SnapDataDTO var2, ApiMetadata var3, ThemeMapReport var4, ExecuteContext var5);
}

