/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentBody;
import com.digiwin.athena.show.component.AbstractComponentHeader;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponent;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponentImpl;
import com.digiwin.athena.show.component.panel.PanelComponent;
import com.digiwin.athena.show.component.panel.PanelComponentImpl;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataScreenPageTemplate
extends AgileReportPageTemplate {
    @Autowired
    private PanelComponentImpl panelComponentImpl;
    @Autowired
    private LabelTitleComponentImpl labelTitleComponent;
    @Autowired
    private MessageUtils messageUtils;

    public String supportKey() {
        return "AGILE_DATA_TEMPLATE_SCREEN";
    }

    protected List<AgileDataBestShowRule> getBestShowRules(ExecuteContext executeContext) {
        return Lists.newArrayList();
    }

    protected AbstractComponent createNoneDataComponent(ThemeMapReport themeMapReport, ExecuteContext executeContext, DynamicAgileData dynamicAgileData) {
        if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
            return null;
        }
        if (this.isEmptyData(themeMapReport)) {
            PanelComponent panelComponent = (PanelComponent)this.panelComponentImpl.initComponent(new MetadataField(), null);
            panelComponent.setId(themeMapReport.getActionId());
            AbstractComponentHeader header = new AbstractComponentHeader();
            if (StringUtils.isNotEmpty((String)themeMapReport.getTitle())) {
                header.setTitle(themeMapReport.getTitle());
                header.setTitlePosition("left");
            }
            LabelTitleComponent titleComponent = (LabelTitleComponent)this.labelTitleComponent.initComponent(new MetadataField(), null);
            titleComponent.setId(themeMapReport.getActionId() + "_label");
            AbstractComponentBody body = new AbstractComponentBody();
            body.setGroup(Arrays.asList(titleComponent));
            panelComponent.setBody(body);
            panelComponent.setHeader(header);
            HashMap data = Maps.newHashMap();
            data.put(titleComponent.getTitle(), this.messageUtils.getMessage("exception.agileReport.screen.empty.data"));
            return panelComponent;
        }
        return null;
    }

    private boolean isEmptyData(ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty((Collection)themeMapReport.getPageData())) {
            return true;
        }
        if (themeMapReport.getApiMetadata() == null) {
            return true;
        }
        Optional<MetadataField> metadataField = themeMapReport.getApiMetadata().getResponseFields().stream().filter(field -> field.isObjectField() && CollectionUtils.isEmpty((Collection)field.getSubFields())).findFirst();
        return metadataField.isPresent();
    }
}

