/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.assistant.AgileReportShowTypeEnum;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.labelTitle.LabelTitleComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBusinessProcess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataBusinessProcessImpl
implements AgileDataBusinessProcess {
    @Autowired
    private LabelTitleComponentImpl labelTitleComponent;

    public List<AbstractComponent> process(List<AgileDataRelationDTO> agileDataRelationDTOList, ExecuteContext executeContext, List<AbstractComponent> components, AgileReport agileReport) {
        Map abstractComponentsMap;
        List abstractComponentList;
        List abstractComponents = components;
        if (CollectionUtils.isNotEmpty(components) && CollectionUtils.isNotEmpty((Collection)(abstractComponentList = this.createTitleComponents(executeContext, abstractComponentsMap = this.getAbstractComponentsMap(components), agileReport)))) {
            abstractComponents = abstractComponentList;
            this.bindShowBest(agileDataRelationDTOList, abstractComponentsMap, agileReport);
        }
        return abstractComponents;
    }

    private void bindShowBest(List<AgileDataRelationDTO> agileDataRelationDTOList, Map<String, List<AbstractComponent>> abstractComponentsMap, AgileReport agileReport) {
        abstractComponentsMap.forEach((k, v) -> {
            String actionId = "";
            String type = "";
            ThemeMapReport themeMapReport = agileReport.getReport().stream().filter(report -> StringUtils.equals((CharSequence)k, (CharSequence)report.getDataSource())).findFirst().orElse(null);
            if (themeMapReport != null) {
                String agileDataShow = themeMapReport.getReportShow().toString();
                type = AgileReportShowTypeEnum.getType((String)agileDataShow);
                actionId = themeMapReport.getActionId();
            }
            this.bindComponentId(agileDataRelationDTOList, actionId, v, type);
        });
    }

    private void bindComponentId(List<AgileDataRelationDTO> agileDataRelationDTOList, String actionId, List<AbstractComponent> componentList, String type) {
        if (CollectionUtils.isNotEmpty(agileDataRelationDTOList)) {
            agileDataRelationDTOList.stream().forEach(relation -> {
                if (StringUtils.equals((CharSequence)actionId, (CharSequence)relation.getActionId())) {
                    relation.setType(type);
                    if (CollectionUtils.isNotEmpty((Collection)relation.getAbstractComponents())) {
                        relation.getAbstractComponents().addAll(componentList);
                    } else {
                        relation.setAbstractComponents(componentList);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)relation.getSubAction())) {
                    this.bindComponentId(relation.getSubAction(), actionId, componentList, type);
                }
            });
        }
    }

    private Map<String, List<AbstractComponent>> getAbstractComponentsMap(List<AbstractComponent> components) {
        HashMap abstractComponentsMap = Maps.newHashMap();
        components.stream().forEach(component -> {
            if (component.getId() != null) {
                if (abstractComponentsMap.containsKey(component.getId())) {
                    ((List)abstractComponentsMap.get(component.getId())).add(component);
                    return;
                }
                ArrayList componentList = Lists.newArrayList();
                componentList.add(component);
                abstractComponentsMap.put(component.getId(), componentList);
            }
        });
        return abstractComponentsMap;
    }

    private List<AbstractComponent> createTitleComponents(ExecuteContext executeContext, Map<String, List<AbstractComponent>> abstractComponentsMap, AgileReport agileReport) {
        if (StringUtils.isNotEmpty((CharSequence)executeContext.getEntry()) && !StringUtils.equals((CharSequence)"0", (CharSequence)executeContext.getEntry())) {
            return abstractComponentsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        ArrayList abstractComponents = Lists.newArrayList();
        abstractComponentsMap.forEach((k, v) -> {
            ArrayList components = Lists.newArrayList();
            ThemeMapReport themeMapReport = agileReport.getReport().stream().filter(report -> report.getDataSource().equals(k)).findFirst().get();
            String labelSchema = "agileData_label_";
            AtomicInteger pageNum = new AtomicInteger();
            AbstractComponent labelComponent = this.labelTitleComponent.initComponent(new MetadataField(), new BuildContext());
            components.add(labelComponent);
            labelComponent.setId(labelSchema + pageNum);
            labelComponent.setId(themeMapReport.getActionId());
            v.stream().forEach(component -> {
                if (StringUtils.isNotEmpty((CharSequence)component.getTitle())) {
                    component.setTitle("");
                }
                abstractComponents.add(component);
                components.add(component);
            });
            v.clear();
            v.addAll(components);
            pageNum.getAndIncrement();
        });
        return abstractComponents;
    }
}

