/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.domain.SceneSelectInfo;
import com.digiwin.athena.agiledataecho.service.MoreActionUserSelectService;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentBody;
import com.digiwin.athena.show.component.AbstractComponentField;
import com.digiwin.athena.show.component.AbstractComponentHeader;
import com.digiwin.athena.show.component.card.CardBody;
import com.digiwin.athena.show.component.card.CardComponent;
import com.digiwin.athena.show.component.card.CardComponentImpl;
import com.digiwin.athena.show.component.card.CardFooter;
import com.digiwin.athena.show.component.card.CardHeader;
import com.digiwin.athena.show.component.list.ListComponent;
import com.digiwin.athena.show.component.list.ListComponentImpl;
import com.digiwin.athena.show.component.multipleSelect.MultipleSelectComponentImpl;
import com.digiwin.athena.show.component.panel.PanelComponent;
import com.digiwin.athena.show.component.panel.PanelComponentImpl;
import com.digiwin.athena.show.component.progressBar.ProgressBarComponent;
import com.digiwin.athena.show.component.progressBar.ProgressBarComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataAreaDefine;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportCard;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportCardDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataCardInterpreter;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataCardInterpreterImpl
implements AgileDataCardInterpreter {
    @Autowired
    private PanelComponentImpl panelComponentImpl;
    @Autowired
    private MultipleSelectComponentImpl multipleSelectComponent;
    @Autowired
    private ProgressBarComponentImpl progressBarComponentImpl;
    @Autowired
    private CardComponentImpl cardComponentImpl;
    @Autowired
    private ListComponentImpl listComponentImpl;
    @Autowired
    private MoreActionUserSelectService moreActionUserSelectService;

    public AbstractComponent interpreter(ThemeMapReport themeMapReport, BuildContext buildContext) {
        if (themeMapReport != null) {
            AgileReportCard agileReportCard = themeMapReport.getCard();
            if (agileReportCard.getCardDefine() == null) {
                return null;
            }
            ProgressBarComponent progressBarComponent = this.createProgressBar(themeMapReport, buildContext);
            CardComponent cardComponent = this.createCard(themeMapReport, progressBarComponent, buildContext);
            ArrayList components = Lists.newArrayList();
            components.add(cardComponent);
            ListComponent listComponent = this.createList(themeMapReport, (List)components, buildContext);
            components = Lists.newArrayList();
            components.add(listComponent);
            PanelComponent panelComponent = this.createPanel(themeMapReport, (List)components, buildContext);
            if (panelComponent == null) {
                return listComponent;
            }
            return panelComponent;
        }
        return null;
    }

    private void setPanelPageData(PanelComponent panelComponent, List<String> userSelectInfo, ThemeMapReport themeMapReport) {
        HashMap pageData = Maps.newHashMap();
    }

    private ListComponent createList(ThemeMapReport themeMapReport, List<AbstractComponent> components, BuildContext buildContext) {
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata);
        ListComponent listComponent = (ListComponent)this.listComponentImpl.initComponent(rootFiled, buildContext);
        listComponent.setItemsLayout("horizontal");
        listComponent.setGroup(components);
        listComponent.setIsFit(Boolean.valueOf(true));
        listComponent.setPagination((Map)Maps.newHashMap());
        listComponent.setId(themeMapReport.getDataSource());
        return listComponent;
    }

    private CardComponent createCard(ThemeMapReport themeMapReport, ProgressBarComponent progressBarComponent, BuildContext buildContext) {
        AgileReportCardDTO.AgileReportCardInfo footer;
        Optional<AgileDataAreaDefine> showFieldsOption;
        AgileReportCardDTO.AgileReportCardInfo body;
        AgileReportCard agileReportCard = themeMapReport.getCard();
        MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField((ApiMetadata)themeMapReport.getApiMetadata());
        Map filedMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getDataSource(), (ApiMetadata)themeMapReport.getApiMetadata());
        CardComponent cardComponent = (CardComponent)this.cardComponentImpl.initComponent(rootFiled, buildContext);
        cardComponent.setId(themeMapReport.getDataSource() + "_card");
        cardComponent.setPath(cardComponent.getId());
        cardComponent.setId(null);
        AgileReportCardDTO.AgileReportCardInfo header = agileReportCard.getCardDefine().getHeader();
        if (header != null) {
            ArrayList fields = Lists.newArrayList();
            header.getAreaDefine().stream().forEach(item -> {
                if (MapUtils.isEmpty((Map)filedMap)) {
                    return;
                }
                MetadataField metadataField = (MetadataField)filedMap.get(item.getApplyToField());
                if (metadataField == null) {
                    return;
                }
                AbstractComponentField field = new AbstractComponentField();
                field.setPath(rootFiled.getName());
                field.setSchema(metadataField.getName());
                field.setLabel(this.getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                field.setPosition(item.getPosition());
                field.setFormat(metadataField.getPercent());
                field.setLevel(item.getLevel());
                field.setColor(item.getColor());
                fields.add(field);
            });
            CardHeader cardHeader = new CardHeader();
            cardHeader.setTitles((List)fields);
            cardComponent.setHeader(cardHeader);
        }
        if ((body = agileReportCard.getCardDefine().getBody()) != null && (showFieldsOption = body.getAreaDefine().stream().filter(item -> StringUtils.equals((String)"showFields", (String)item.getType())).findFirst()).isPresent()) {
            AgileDataAreaDefine showFields = showFieldsOption.get();
            CardBody cardBody = new CardBody();
            ArrayList fields = Lists.newArrayList();
            showFields.getAreaDefine().stream().forEach(item -> {
                if (MapUtils.isEmpty((Map)filedMap)) {
                    return;
                }
                MetadataField metadataField = (MetadataField)filedMap.get(item.getApplyToField());
                if (metadataField == null) {
                    return;
                }
                AbstractComponentField field = new AbstractComponentField();
                field.setPath(rootFiled.getName());
                field.setSchema(item.getApplyToField());
                field.setLabel(this.getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                field.setFormat(metadataField.getPercent());
                field.setPosition(item.getPosition());
                field.setLevel(item.getLevel());
                field.setColor(item.getColor());
                fields.add(field);
            });
            ArrayList group = Lists.newArrayList();
            if (progressBarComponent != null) {
                group.add(progressBarComponent);
            }
            cardBody.setGroup((List)group);
            cardBody.setFields((List)fields);
            cardBody.setFieldsLayout(showFieldsOption.get().getFieldsLayout());
            cardComponent.setBody(cardBody);
        }
        if ((footer = agileReportCard.getCardDefine().getFooter()) != null) {
            ArrayList fields = Lists.newArrayList();
            footer.getAreaDefine().stream().forEach(item -> {
                if (MapUtils.isEmpty((Map)filedMap)) {
                    return;
                }
                MetadataField metadataField = (MetadataField)filedMap.get(item.getApplyToField());
                if (metadataField == null) {
                    return;
                }
                AbstractComponentField field = new AbstractComponentField();
                field.setPath(rootFiled.getName());
                field.setSchema(metadataField.getName());
                field.setLabel(this.getLabel(metadataField, item.getLabel(), item.getShowLabel()));
                field.setPosition(item.getPosition());
                field.setLevel(item.getLevel());
                field.setFormat(metadataField.getPercent());
                field.setColor(item.getColor());
                fields.add(field);
            });
            CardFooter cardFooter = new CardFooter();
            cardFooter.setFields((List)fields);
            cardFooter.setFieldsLayout(footer.getFieldsLayout());
            cardComponent.setFooter(cardFooter);
        }
        return cardComponent;
    }

    private ProgressBarComponent createProgressBar(ThemeMapReport themeMapReport, BuildContext buildContext) {
        Optional<AgileDataAreaDefine> progressBar;
        AgileReportCard agileReportCard = themeMapReport.getCard();
        AgileReportCardDTO.AgileReportCardInfo body = agileReportCard.getCardDefine().getBody();
        if (body != null && (progressBar = body.getAreaDefine().stream().filter(item -> StringUtils.equals((String)"dynamicModule", (String)item.getType())).findFirst()).isPresent()) {
            MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField((ApiMetadata)themeMapReport.getApiMetadata());
            Map filedMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getDataSource(), (ApiMetadata)themeMapReport.getApiMetadata());
            AgileDataAreaDefine dynamicModule = progressBar.get();
            ProgressBarComponent progressBarComponent = (ProgressBarComponent)this.progressBarComponentImpl.initComponent(rootFiled, buildContext);
            progressBarComponent.setProgressType(dynamicModule.getProgressType());
            progressBarComponent.setId(progressBarComponent.getId());
            progressBarComponent.setId(null);
            ArrayList fields = Lists.newArrayList();
            dynamicModule.getAreaDefine().stream().forEach(item -> {
                if (MapUtils.isEmpty((Map)filedMap)) {
                    return;
                }
                MetadataField filed = (MetadataField)filedMap.get(item.getApplyToField());
                if (filed == null) {
                    return;
                }
                HashMap fieldMap = Maps.newHashMap();
                fieldMap.put("schema", item.getApplyToField());
                fieldMap.put("label", this.getLabel(filed, item.getLabel(), item.getShowLabel()));
                fieldMap.put("format", filed != null ? filed.getPercent() : null);
                fieldMap.put("color", item.getColor());
                fields.add(fieldMap);
            });
            if (CollectionUtils.isEmpty((Collection)fields)) {
                return null;
            }
            progressBarComponent.setFields((List)fields);
            progressBarComponent.setId(themeMapReport.getDataSource() + "_progress");
            return progressBarComponent;
        }
        return null;
    }

    public PanelComponent createPanel(ThemeMapReport themeMapReport, List<AbstractComponent> components, BuildContext buildContext) {
        AgileReportCard agileReportCard = themeMapReport.getCard();
        if (agileReportCard.getFilter() != null) {
            ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
            MetadataField rootFiled = ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata);
            PanelComponent panelComponent = (PanelComponent)this.panelComponentImpl.initComponent(rootFiled, buildContext);
            AbstractComponentHeader header = new AbstractComponentHeader();
            header.setTitle(themeMapReport.getTitle());
            header.setTitlePosition("left");
            HashMap optionMap = Maps.newHashMap();
            LinkedHashMap option = Maps.newLinkedHashMap();
            ArrayList values = Lists.newArrayList();
            AgileReportRuleDTO rule = agileReportCard.getFilter().getAgileReportRule();
            if (rule == null) {
                return panelComponent;
            }
            String showName = "";
            String showValue = "";
            Optional<AgileReportRuleInfoDTO> showNameRule = rule.getRules().stream().filter(item -> StringUtils.equals((String)"showName", (String)item.getType())).findFirst();
            Optional<AgileReportRuleInfoDTO> showValueRule = rule.getRules().stream().filter(item -> StringUtils.equals((String)"showValue", (String)item.getType())).findFirst();
            if (showNameRule.isPresent()) {
                showName = showNameRule.get().getApplyToField();
            }
            if (showValueRule.isPresent()) {
                showValue = showValueRule.get().getApplyToField();
            }
            optionMap.put("option", option);
            buildContext.setOption((Map)optionMap);
            if (CollectionUtils.isNotEmpty((Collection)agileReportCard.getFilter().getPageData())) {
                for (Map item2 : agileReportCard.getFilter().getPageData()) {
                    option.put(MapUtils.getString((Map)item2, (Object)showValue), MapUtils.getString((Map)item2, (Object)showName));
                    values.add(MapUtils.getString((Map)item2, (Object)showValue));
                }
            }
            MetadataField selectFiled = ConvertGetAgileData.getRootMetadataField((ApiMetadata)agileReportCard.getFilter().getApiMetadata());
            AbstractComponent selectComponent = this.multipleSelectComponent.initComponent(selectFiled, buildContext);
            selectComponent.setId(agileReportCard.getFilter().getActionId() + "_select");
            selectComponent.setId(selectComponent.getId());
            selectComponent.setEditable(Boolean.valueOf(true));
            SceneSelectInfo selectInfo = new SceneSelectInfo();
            selectInfo.setSceneCode(buildContext.getExecuteContext().getScreenCode());
            selectInfo.setActionId(selectComponent.getId());
            selectInfo.setType("action");
            List moreSelectInfo = this.moreActionUserSelectService.queryMoreActionUserSelectInfo(selectInfo, buildContext.getExecuteContext().getAuthoredUser());
            ArrayList userSelectInfo = moreSelectInfo.stream().map(Object::toString).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userSelectInfo)) {
                userSelectInfo = values;
            }
            ArrayList group = Lists.newArrayList();
            group.add(selectComponent);
            header.setGroup((List)group);
            header.setGroupPosition("right");
            panelComponent.setHeader(header);
            AbstractComponentBody abstractComponentBody = new AbstractComponentBody();
            components.stream().forEach(item -> item.setPath(panelComponent.getId()));
            abstractComponentBody.setGroup(components);
            panelComponent.setBody(abstractComponentBody);
            panelComponent.setId(themeMapReport.getDataSource() + "_panel");
            this.setPanelPageData(panelComponent, (List)userSelectInfo, themeMapReport);
            return panelComponent;
        }
        return null;
    }

    private String getLabel(MetadataField metadataField, String label, Boolean isShowLabel) {
        if (BooleanUtils.isTrue((Boolean)isShowLabel)) {
            if (StringUtils.isNotEmpty((String)label)) {
                return label;
            }
            if (metadataField != null) {
                return metadataField.getDescription();
            }
        }
        return null;
    }
}

