/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.util.layout;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AgileDataCheck {
    public static Boolean screenBasicCheck(SnapDataDTO agileReportDTO) {
        if (agileReportDTO == null || agileReportDTO.getSnapData() == null || MapUtils.isEmpty((Map)agileReportDTO.getPageData())) {
            return true;
        }
        return false;
    }

    public static Boolean sceneBasicCheck(SnapDataDTO agileReportDTO) {
        if (agileReportDTO == null || MapUtils.isEmpty((Map)agileReportDTO.getPageData()) || agileReportDTO.getSnapData() == null) {
            return true;
        }
        Iterator iterator = agileReportDTO.getPageData().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof List)) continue;
            List dataList = (List)entry.getValue();
            dataList.removeIf(data -> !data.containsKey("data") || data.get("data") == null);
            if (!CollectionUtils.isEmpty((Collection)dataList)) continue;
            iterator.remove();
        }
        if (MapUtils.isEmpty((Map)agileReportDTO.getPageData())) {
            return true;
        }
        return false;
    }

    public static Boolean isScreen(ExecuteContext executeContext) {
        Map agileData = executeContext.getAgileData();
        String entry = MapUtils.getString((Map)agileData, (Object)"entry");
        if (StringUtils.isNotEmpty((String)entry)) {
            return "1".equals(entry);
        }
        return false;
    }
}

