package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoQueryBackIdReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoSelectMultipleReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/22 13:57
 * @Description:
 */
@RestController
@RequestMapping(value = "/api/ai/agile/echo/exception")
public class EchoInformationController {

    @Autowired
    private EchoInformationService echoInformationService;

    @PostMapping("/submit")
    public ResponseEntity<?> submit(@RequestBody @Validated EchoInformationReqDTO echoInformationReqDTO,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        echoInformationService.submit(echoInformationReqDTO,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 通过snapshotId和userId查询快照信息
     */
    @GetMapping("/queryInfo/{messageId}")
    public ResponseEntity<?> getExceptionInfoByMessageId(@PathVariable("messageId") String messageId,
                                                       @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoInformationService.getExceptionInfoByMessageId(messageId,user));
    }

    @PostMapping("/mongo/submit")
    public ResponseEntity<?> mongoSubmit(@RequestBody @Validated EchoInformationReqDTO echoInformationReqDTO,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        echoInformationService.mongoSubmit(echoInformationReqDTO,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/mongo/get/{messageId}")
    public ResponseEntity<?> getMongoDbEchoInfoByMessageId(@PathVariable("messageId") String messageId,
                                                           @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoInformationService.getMongoDbEchoInfoByMessageId(messageId,user));
    }

    @PostMapping("/mongo/metric/check")
    public ResponseEntity<?> sendMetricCheck(@RequestBody @Validated Map<String,Object> request,
                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        echoInformationService.sendMetricCheck(request,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/mongo/metric/get/{messageId}")
    public ResponseEntity<?> getMongoDbMetricInfoByMessageId(@PathVariable("messageId") String messageId,
                                                           @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoInformationService.getMongoDbMetricInfoByMessageId(messageId,user));
    }

    /**
     * 通过snapshotId和userId查询快照信息
     */
    @PostMapping("/queryPixBackendList")
    public ResponseEntity<?> queryPixBackendList(@RequestBody EchoQueryBackIdReqDTO echoQueryBackIdReqDTO,
                                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoInformationService.queryPixBackendList(echoQueryBackIdReqDTO,user));
    }

    /**
     * 分析回答结果
     * @param request
     * @param analysisData
     * @param user
     * @return
     */
    @PostMapping("/queryAnalysisResult")
    public ResponseEntity<?> queryAnalysisResult(HttpServletRequest request,
                                                 @RequestBody Map<String,Object> analysisData,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(echoInformationService.getAgileDataAnalysis(analysisData,user,locale));
    }

    @PostMapping("/mongo/multiple/submit")
    public ResponseEntity<?> mongoSubmit(@RequestBody @Validated EchoSelectMultipleReqDTO echoSelectMultipleReqDTO,
                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        echoInformationService.mongoMultipleSubmit(echoSelectMultipleReqDTO,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping("/mongo/get/multiple/{messageId}")
    public ResponseEntity<?> getMongoMultipleLogByMessageId(@PathVariable("messageId") String messageId,
                                                           @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoInformationService.getMongoMultipleLogByMessageId(messageId,user));
    }
}
