package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.EchoExperienceRoleConfigDataQueryDTO;
import com.digiwin.athena.agiledataecho.dto.EchoPageConfigProductBulletinQueryDTO;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoOpeningRemarksConfigData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoProductBulletinConfigData;
import com.digiwin.athena.agiledataecho.service.EchoPageConfigService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 页面配置Controller
 *
 * @author yanfeng
 * @date 2024/8/21
 */
@RestController
@RequestMapping(value = "/api/ai/agile/echo/page/config")
public class EchoPageConfigController {

    @Autowired
    private EchoPageConfigService echoPageConfigService;

    @PostMapping("/queryProductBulletinList")
    public ResponseEntity<?> queryProductBulletinList(@RequestBody EchoPageConfigProductBulletinQueryDTO queryDTO,
                                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryProductBulletinList(user, queryDTO));
    }

    @PostMapping("/saveProductBulletin")
    public ResponseEntity<?> saveProductBulletin(@RequestBody EchoProductBulletinConfigData saveDTO,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.saveProductBulletinConfig(user, saveDTO));
    }

    @PostMapping("/saveOpeningRemarksConfig")
    public ResponseEntity<?> saveOpeningRemarksConfig(@RequestBody EchoOpeningRemarksConfigData saveDTO,
                                                      @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.saveOpeningRemarksConfig(user, saveDTO));
    }

    @PostMapping("/queryOpeningRemarksConfig")
    public ResponseEntity<?> queryOpeningRemarksConfig(@RequestBody EchoPageConfigProductBulletinQueryDTO queryDTO,
                                                       @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryOpeningRemarksConfig(user, queryDTO));
    }

    @PostMapping("/queryExperienceRoleConfigList")
    public ResponseEntity<?> queryExperienceRoleConfigList(@RequestBody EchoExperienceRoleConfigDataQueryDTO queryDTO) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryExperienceRoleConfigList(queryDTO));
    }

    @PostMapping("/queryLiteUploadLimitationsConfig")
    public ResponseEntity<?> queryExperienceRoleConfigList(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryLiteUploadLimitationsConfig(user));
    }

    @PostMapping("/queryCommandIntentions")
    public ResponseEntity<?> queryCommandIntentions(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryCommandIntentions(user));
    }

    @PostMapping("/queryFuzzyMatchingConfig")
    public ResponseEntity<?> queryFuzzyMatchingConfig(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoPageConfigService.queryFuzzyMatchingConfig(user));
    }

}